"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloDetailsAlerts = SloDetailsAlerts;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _sloSchema = require("@kbn/slo-schema");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ALERTS_TABLE_ID = 'xpack.observability.slo.sloDetails.alertTable';
function SloDetailsAlerts({
  slo
}) {
  var _slo$instanceId;
  const {
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable
    }
  } = (0, _kibana_react.useKibana)().services;
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
    alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
    configurationId: _ruleDataUtils.AlertConsumers.OBSERVABILITY,
    id: ALERTS_TABLE_ID,
    "data-test-subj": "alertTable",
    featureIds: [_ruleDataUtils.AlertConsumers.SLO, _ruleDataUtils.AlertConsumers.OBSERVABILITY],
    query: {
      bool: {
        filter: [{
          term: {
            'slo.id': slo.id
          }
        }, {
          term: {
            'slo.instanceId': (_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE
          }
        }]
      }
    },
    showAlertStatusWithFlapping: true,
    pageSize: 100
  }))));
}