"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsChartPanel = EventsChartPanel;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _public = require("@kbn/charts-plugin/public");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _use_get_preview_data = require("../../../hooks/slo/use_get_preview_data");
var _kibana_react = require("../../../utils/kibana_react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EventsChartPanel({
  slo,
  range
}) {
  var _data$map, _data$map2;
  const {
    charts,
    uiSettings
  } = (0, _kibana_react.useKibana)().services;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    isLoading,
    data
  } = (0, _use_get_preview_data.useGetPreviewData)(true, slo.indicator, range);
  const theme = charts.theme.useChartsTheme();
  const baseTheme = charts.theme.useChartsBaseTheme();
  const chartRef = (0, _react.useRef)(null);
  const handleCursorUpdate = (0, _public.useActiveCursor)(charts.activeCursor, chartRef, {
    isDateHistogram: true
  });
  const dateFormat = uiSettings.get('dateFormat');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "eventsChartPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.slo.sloDetails.eventsChartPanel.title', {
    defaultMessage: 'Good vs bad events'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.slo.sloDetails.eventsChartPanel.duration', {
    defaultMessage: 'Last 24h'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingChart, {
    size: "m",
    mono: true,
    "data-test-subj": "sliEventsChartLoading"
  }), !isLoading && /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 150,
      width: '100%'
    },
    ref: chartRef
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.VerticalCursor
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    showLegend: true,
    showLegendExtra: false,
    legendPosition: _charts.Position.Left,
    theme: [theme],
    noResults: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visualizeApp",
      size: "l",
      color: "subdued",
      title: "no results"
    }),
    onPointerUpdate: handleCursorUpdate,
    externalPointerEvents: {
      tooltip: {
        visible: true
      }
    },
    pointerUpdateDebounce: 0,
    pointerUpdateTrigger: 'x',
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    showOverlappingTicks: true,
    tickFormat: d => (0, _moment.default)(d).format(dateFormat)
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "left",
    position: _charts.Position.Left,
    tickFormat: d => (0, _numeral.default)(d).format('0,0')
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: _i18n.i18n.translate('xpack.observability.slo.sloDetails.eventsChartPanel.goodEventsLabel', {
      defaultMessage: 'Good events'
    }),
    color: euiTheme.colors.success,
    barSeriesStyle: {
      rect: {
        fill: euiTheme.colors.success
      },
      displayValue: {
        fill: euiTheme.colors.success
      }
    },
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['value'],
    stackAccessors: [0],
    data: (_data$map = data === null || data === void 0 ? void 0 : data.map(datum => {
      var _datum$events;
      return {
        key: new Date(datum.date).getTime(),
        value: (_datum$events = datum.events) === null || _datum$events === void 0 ? void 0 : _datum$events.good
      };
    })) !== null && _data$map !== void 0 ? _data$map : []
  }), /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: _i18n.i18n.translate('xpack.observability.slo.sloDetails.eventsChartPanel.badEventsLabel', {
      defaultMessage: 'Bad events'
    }),
    color: euiTheme.colors.danger,
    barSeriesStyle: {
      rect: {
        fill: euiTheme.colors.danger
      },
      displayValue: {
        fill: euiTheme.colors.danger
      }
    },
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "key",
    yAccessors: ['value'],
    stackAccessors: [0],
    data: (_data$map2 = data === null || data === void 0 ? void 0 : data.map(datum => {
      var _datum$events2;
      return {
        key: new Date(datum.date).getTime(),
        value: (_datum$events2 = datum.events) === null || _datum$events2 === void 0 ? void 0 : _datum$events2.bad
      };
    })) !== null && _data$map2 !== void 0 ? _data$map2 : []
  })))));
}