"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRates = BurnRates;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var _error_rate_chart = require("../../../components/slo/error_rate_chart");
var _use_fetch_slo_burn_rates = require("../../../hooks/slo/use_fetch_slo_burn_rates");
var _burn_rate = require("./burn_rate");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CRITICAL = 'CRITICAL';
const HIGH = 'HIGH';
const MEDIUM = 'MEDIUM';
const LOW = 'LOW';
const WINDOWS = [{
  name: CRITICAL,
  duration: '1h'
}, {
  name: HIGH,
  duration: '6h'
}, {
  name: MEDIUM,
  duration: '24h'
}, {
  name: LOW,
  duration: '72h'
}];
const TIME_RANGE_OPTIONS = [{
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.observability.slo.burnRates.fromRange.1hLabel', {
    defaultMessage: '1h'
  }),
  windowName: CRITICAL,
  threshold: 14.4,
  duration: 1
}, {
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.observability.slo.burnRates.fromRange.6hLabel', {
    defaultMessage: '6h'
  }),
  windowName: HIGH,
  threshold: 6,
  duration: 6
}, {
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.observability.slo.burnRates.fromRange.24hLabel', {
    defaultMessage: '24h'
  }),
  windowName: MEDIUM,
  threshold: 3,
  duration: 24
}, {
  id: (0, _eui.htmlIdGenerator)()(),
  label: _i18n.i18n.translate('xpack.observability.slo.burnRates.fromRange.72hLabel', {
    defaultMessage: '72h'
  }),
  windowName: LOW,
  threshold: 1,
  duration: 72
}];
function BurnRates({
  slo,
  isAutoRefreshing
}) {
  var _data$burnRates$find;
  const {
    isLoading,
    data
  } = (0, _use_fetch_slo_burn_rates.useFetchSloBurnRates)({
    slo,
    shouldRefetch: isAutoRefreshing,
    windows: WINDOWS
  });
  const [timeRangeIdSelected, setTimeRangeIdSelected] = (0, _react.useState)(TIME_RANGE_OPTIONS[0].id);
  const [timeRange, setTimeRange] = (0, _react.useState)(TIME_RANGE_OPTIONS[0]);
  const onChange = optionId => {
    setTimeRangeIdSelected(optionId);
  };
  (0, _react.useEffect)(() => {
    var _TIME_RANGE_OPTIONS$f;
    const selected = (_TIME_RANGE_OPTIONS$f = TIME_RANGE_OPTIONS.find(opt => opt.id === timeRangeIdSelected)) !== null && _TIME_RANGE_OPTIONS$f !== void 0 ? _TIME_RANGE_OPTIONS$f : TIME_RANGE_OPTIONS[0];
    setTimeRange(selected);
  }, [timeRangeIdSelected]);
  const fromRange = (0, _moment.default)().subtract(timeRange.duration, 'hour').toDate();
  const threshold = timeRange.threshold;
  const burnRate = data === null || data === void 0 ? void 0 : (_data$burnRates$find = data.burnRates.find(br => br.name === timeRange.windowName)) === null || _data$burnRates$find === void 0 ? void 0 : _data$burnRates$find.burnRate;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "m",
    color: "transparent",
    hasBorder: true,
    "data-test-subj": "burnRatePanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observability.slo.burnRate.title', {
    defaultMessage: 'Burn rate'
  }), ' '))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    label: _i18n.i18n.translate('xpack.observability.slo.burnRate.technicalPreviewBadgeTitle', {
      defaultMessage: 'Technical Preview'
    }),
    size: "s",
    tooltipPosition: "bottom",
    tooltipContent: _i18n.i18n.translate('xpack.observability.slo.burnRate.technicalPreviewBadgeDescription', {
      defaultMessage: 'This functionality is in technical preview and is subject to change or may be removed in future versions. The design and code is less mature than official generally available features and is being provided as-is with no warranties. Technical preview features are not subject to the support service level agreement of official generally available features.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
    legend: _i18n.i18n.translate('xpack.observability.slo.burnRate.timeRangeBtnLegend', {
      defaultMessage: 'Select the time range'
    }),
    options: TIME_RANGE_OPTIONS,
    idSelected: timeRangeIdSelected,
    onChange: id => onChange(id),
    buttonSize: "compressed"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_burn_rate.BurnRate, {
    threshold: threshold,
    burnRate: burnRate,
    slo: slo,
    isLoading: isLoading
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_error_rate_chart.ErrorRateChart, {
    slo: slo,
    fromRange: fromRange
  })))));
}