"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BurnRate = BurnRate;
var _eui = require("@elastic/eui");
var _numeral = _interopRequireDefault(require("@elastic/numeral"));
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireDefault(require("react"));
var _duration = require("../../../utils/slo/duration");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getTitleFromStatus(status) {
  if (status === 'NO_DATA') return _i18n.i18n.translate('xpack.observability.slo.burnRate.noDataStatusTitle', {
    defaultMessage: 'No value'
  });
  if (status === 'BREACHED') return _i18n.i18n.translate('xpack.observability.slo.burnRate.breachedStatustTitle', {
    defaultMessage: 'Critical value breached'
  });
  return _i18n.i18n.translate('xpack.observability.slo.burnRate.okStatusTitle', {
    defaultMessage: 'Acceptable value'
  });
}
function getSubtitleFromStatus(status, burnRate = 1, slo) {
  if (status === 'NO_DATA') return _i18n.i18n.translate('xpack.observability.slo.burnRate.noDataStatusSubtitle', {
    defaultMessage: 'Waiting for more data.'
  });
  if (status === 'BREACHED') return _i18n.i18n.translate('xpack.observability.slo.burnRate.breachedStatustSubtitle', {
    defaultMessage: 'At current rate, the error budget will be exhausted in {hour} hours.',
    values: {
      hour: (0, _numeral.default)(_moment.default.duration((0, _duration.toMinutes)((0, _duration.toDuration)(slo.timeWindow.duration)) / burnRate, 'minutes').asHours()).format('0')
    }
  });
  return _i18n.i18n.translate('xpack.observability.slo.burnRate.okStatusSubtitle', {
    defaultMessage: 'There is no risk of error budget exhaustion.'
  });
}
function BurnRate({
  threshold,
  burnRate,
  slo,
  isLoading
}) {
  const status = burnRate === undefined ? 'NO_DATA' : burnRate > threshold ? 'BREACHED' : 'OK';
  const color = status === 'NO_DATA' ? 'subdued' : status === 'BREACHED' ? 'danger' : 'success';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: color,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "column",
    style: {
      minHeight: '100%'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "default",
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h5", null, getTitleFromStatus(status)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, getSubtitleFromStatus(status, burnRate, slo)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "flexEnd",
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiStat, {
    title: burnRate !== undefined ? `${(0, _numeral.default)(burnRate).format('0.[00]')}x` : '--',
    titleColor: "default",
    titleSize: "s",
    textAlign: "right",
    isLoading: isLoading,
    "data-test-subj": "sloDetailsBurnRateStat",
    description: /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "default"
    }, /*#__PURE__*/_react.default.createElement("span", null, _i18n.i18n.translate('xpack.observability.slo.burnRate.threshold', {
      defaultMessage: 'Threshold is {threshold}x',
      values: {
        threshold
      }
    })))
  })))));
}