"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleDetailsTabs = RuleDetailsTabs;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana_react = require("../../../utils/kibana_react");
var _alert_search_bar_with_url_sync = require("../../../components/alert_search_bar/alert_search_bar_with_url_sync");
var _common = require("../../../../common");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RuleDetailsTabs({
  activeTabId,
  esQuery,
  featureIds,
  rule,
  ruleId,
  ruleType,
  onSetTabId,
  onEsQueryChange
}) {
  const {
    triggersActionsUi: {
      alertsTableConfigurationRegistry,
      getAlertsStateTable: AlertsStateTable,
      getRuleEventLogList: RuleEventLogList
    }
  } = (0, _kibana_react.useKibana)().services;
  const ruleQuery = (0, _react.useRef)([{
    query: `kibana.alert.rule.uuid: ${ruleId}`,
    language: 'kuery'
  }]);
  const tabs = [{
    id: _constants.RULE_DETAILS_EXECUTION_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.eventLogTabText', {
      defaultMessage: 'Execution history'
    }),
    'data-test-subj': 'eventLogListTab',
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        minHeight: 600
      },
      direction: 'column'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, rule && ruleType ? /*#__PURE__*/_react.default.createElement(RuleEventLogList, {
      ruleId: rule.id,
      ruleType: ruleType
    }) : null))
  }, {
    id: _constants.RULE_DETAILS_ALERTS_TAB,
    name: _i18n.i18n.translate('xpack.observability.ruleDetails.rule.alertsTabText', {
      defaultMessage: 'Alerts'
    }),
    'data-test-subj': 'ruleAlertListTab',
    content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_alert_search_bar_with_url_sync.ObservabilityAlertSearchbarWithUrlSync, {
      appName: _constants.RULE_DETAILS_ALERTS_SEARCH_BAR_ID,
      onEsQueryChange: onEsQueryChange,
      urlStorageKey: _constants.RULE_DETAILS_SEARCH_BAR_URL_STORAGE_KEY,
      defaultSearchQueries: ruleQuery.current
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      style: {
        minHeight: 450
      },
      direction: 'column'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, esQuery && featureIds && /*#__PURE__*/_react.default.createElement(AlertsStateTable, {
      alertsTableConfigurationRegistry: alertsTableConfigurationRegistry,
      configurationId: _common.observabilityFeatureId,
      id: _constants.RULE_DETAILS_PAGE_ID,
      featureIds: featureIds,
      query: esQuery,
      showAlertStatusWithFlapping: true
    }))))
  }];
  const handleTabIdChange = newTabId => {
    onSetTabId(newTabId);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiTabbedContent, {
    "data-test-subj": "ruleDetailsTabbedContent",
    tabs: tabs,
    selectedTab: tabs.find(tab => tab.id === activeTabId),
    onTabClick: tab => {
      handleTabIdChange(tab.id);
    }
  });
}