"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricWithSparkline = MetricWithSparkline;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui_charts_theme = require("@elastic/eui/dist/eui_charts_theme");
var _styledComponents = require("styled-components");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetricWithSparkline({
  id,
  formatter,
  value,
  timeseries,
  color
}) {
  var _theme$1$colors$vizCo, _theme$1$colors;
  const themeCTX = (0, _react.useContext)(_styledComponents.ThemeContext);
  const isDarkTheme = themeCTX && themeCTX.darkMode || false;
  const theme = [_eui_charts_theme.EUI_SPARKLINE_THEME_PARTIAL, isDarkTheme ? _eui_charts_theme.EUI_CHARTS_THEME_DARK.theme : _eui_charts_theme.EUI_CHARTS_THEME_LIGHT.theme];
  const colors = (_theme$1$colors$vizCo = (_theme$1$colors = theme[1].colors) === null || _theme$1$colors === void 0 ? void 0 : _theme$1$colors.vizColors) !== null && _theme$1$colors$vizCo !== void 0 ? _theme$1$colors$vizCo : [];
  if (!value) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visLine"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.metricWithSparkline.nATextColorLabel",
      defaultMessage: "N/A"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 18,
      width: 40
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    theme: theme,
    showLegend: false,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: id,
    data: timeseries,
    xAccessor: 'timestamp',
    yAccessors: [id],
    color: colors[color] || '#006BB4'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      whiteSpace: 'nowrap'
    }
  }, formatter(value)));
}