"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityStatusBoxes = ObservabilityStatusBoxes;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _observability_status_box = require("./observability_status_box");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sortingFn = (a, b) => {
  return a.weight - b.weight;
};
function ObservabilityStatusBoxes({
  boxes
}) {
  const hasDataBoxes = boxes.filter(box => box.hasData).sort(sortingFn);
  const noHasDataBoxes = boxes.filter(box => !box.hasData).sort(sortingFn);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, noHasDataBoxes.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.recommendedSteps",
    defaultMessage: "Recommended next steps"
  })))), noHasDataBoxes.map(box => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: box.id,
    "data-test-id": `box-${box.id}`
  }, /*#__PURE__*/_react.default.createElement(_observability_status_box.EmptyStatusBox, box)))), noHasDataBoxes.length > 0 && hasDataBoxes.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), hasDataBoxes.length > 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.status.dataAvailableTitle",
    defaultMessage: "Data available for"
  })))), hasDataBoxes.map(box => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: box.id,
    "data-test-subj": `box-${box.id}`
  }, /*#__PURE__*/_react.default.createElement(_observability_status_box.CompletedStatusBox, box)))));
}