"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingPage = LandingPage;
var _react = _interopRequireWildcard(require("react"));
var _locators = require("@kbn/deeplinks-observability/locators");
var _use_has_data = require("../../hooks/use_has_data");
var _kibana_react = require("../../utils/kibana_react");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LandingPage() {
  const {
    hasDataMap,
    isAllRequestsComplete
  } = (0, _use_has_data.useHasData)();
  const {
    application: {
      navigateToUrl,
      navigateToApp
    },
    http: {
      basePath
    },
    share: {
      url
    }
  } = (0, _kibana_react.useKibana)().services;
  (0, _react.useEffect)(() => {
    if (isAllRequestsComplete) {
      const {
        apm,
        infra_logs: logs
      } = hasDataMap;
      const hasApmData = apm === null || apm === void 0 ? void 0 : apm.hasData;
      const hasLogsData = logs === null || logs === void 0 ? void 0 : logs.hasData;
      if (hasLogsData) {
        const allDataSetsLocator = url.locators.get(_locators.ALL_DATASETS_LOCATOR_ID);
        allDataSetsLocator === null || allDataSetsLocator === void 0 ? void 0 : allDataSetsLocator.navigate({});
      } else if (hasApmData) {
        navigateToUrl(basePath.prepend('/app/apm/services'));
      } else {
        navigateToUrl(basePath.prepend('/app/observabilityOnboarding'));
      }
    }
  }, [basePath, hasDataMap, isAllRequestsComplete, navigateToApp, navigateToUrl, url.locators]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}