"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderRuleStats = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _uiTheme = require("@kbn/ui-theme");
var _common = require("@kbn/kibana-react-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Divider = _common.euiStyled.div`
  border-right: 1px solid ${_uiTheme.euiThemeVars.euiColorLightShade};
  height: 100%;
`;
const StyledStat = (0, _common.euiStyled)(_eui.EuiStat)`
  .euiText {
    line-height: 1;
  }
`;
const ConditionalWrap = ({
  condition,
  wrap,
  children
}) => condition ? wrap(children) : children;
const getStatCount = (stats, status) => {
  if (status === 'snoozed') return stats.snoozed + stats.muted;
  return stats[status];
};
const renderRuleStats = (ruleStats, manageRulesHref, ruleStatsLoading, rulesLocator) => {
  const handleNavigateToRules = async (stats, status) => {
    const count = getStatCount(stats, status);
    if (count > 0) {
      switch (status) {
        case 'error':
          await (rulesLocator === null || rulesLocator === void 0 ? void 0 : rulesLocator.navigate({
            lastResponse: ['failed']
          }, {
            replace: false
          }));
          break;
        case 'snoozed':
        case 'disabled':
          await (rulesLocator === null || rulesLocator === void 0 ? void 0 : rulesLocator.navigate({
            status: [status]
          }, {
            replace: false
          }));
          break;
        default:
          break;
      }
    }
  };
  const disabledStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.disabled > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yDisabledStatsComponentButton",
      onClick: () => handleNavigateToRules(ruleStats, 'disabled')
    }, wrappedChildren)
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.disabled,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.disabled', {
      defaultMessage: 'Disabled'
    }),
    color: "primary",
    titleColor: ruleStats.disabled > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statDisabled"
  }));
  const snoozedStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.muted + ruleStats.snoozed > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11ySnoozedStatsComponentButton",
      onClick: () => handleNavigateToRules(ruleStats, 'snoozed')
    }, wrappedChildren)
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.muted + ruleStats.snoozed,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.muted', {
      defaultMessage: 'Snoozed'
    }),
    color: "primary",
    titleColor: ruleStats.muted + ruleStats.snoozed > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statMuted"
  }));
  const errorStatsComponent = /*#__PURE__*/_react.default.createElement(ConditionalWrap, {
    condition: ruleStats.error > 0,
    wrap: wrappedChildren => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yErrorStatsComponentButton",
      onClick: () => handleNavigateToRules(ruleStats, 'error')
    }, wrappedChildren)
  }, /*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.error,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.errors', {
      defaultMessage: 'Errors'
    }),
    color: "primary",
    titleColor: ruleStats.error > 0 ? 'primary' : '',
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statErrors"
  }));
  return [/*#__PURE__*/_react.default.createElement(StyledStat, {
    title: ruleStats.total,
    description: _i18n.i18n.translate('xpack.observability.alerts.ruleStats.ruleCount', {
      defaultMessage: 'Rule count'
    }),
    color: "primary",
    titleSize: "xs",
    isLoading: ruleStatsLoading,
    "data-test-subj": "statRuleCount"
  }), disabledStatsComponent, snoozedStatsComponent, errorStatsComponent, /*#__PURE__*/_react.default.createElement(Divider, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "manageRulesPageButton",
    href: manageRulesHref
  }, _i18n.i18n.translate('xpack.observability.alerts.manageRulesButtonLabel', {
    defaultMessage: 'Manage Rules'
  }))].reverse();
};
exports.renderRuleStats = renderRuleStats;