"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _lodash = require("lodash");
var _common = require("@kbn/cases-plugin/common");
var _eui = require("@elastic/eui");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _kibana_react = require("../../../utils/kibana_react");
var _use_fetch_rule = require("../../../hooks/use_fetch_rule");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderActions({
  alert
}) {
  const {
    cases: {
      hooks: {
        useCasesAddToExistingCaseModal
      }
    },
    triggersActionsUi: {
      getEditRuleFlyout: EditRuleFlyout,
      getRuleSnoozeModal: RuleSnoozeModal
    }
  } = (0, _kibana_react.useKibana)().services;
  const {
    rule,
    refetch
  } = (0, _use_fetch_rule.useFetchRule)({
    ruleId: (alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || ''
  });
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const [ruleConditionsFlyoutOpen, setRuleConditionsFlyoutOpen] = (0, _react.useState)(false);
  const [snoozeModalOpen, setSnoozeModalOpen] = (0, _react.useState)(false);
  const selectCaseModal = useCasesAddToExistingCaseModal();
  const handleTogglePopover = () => setIsPopoverOpen(!isPopoverOpen);
  const handleClosePopover = () => setIsPopoverOpen(false);
  const attachments = alert && rule ? [{
    alertId: (alert === null || alert === void 0 ? void 0 : alert.fields[_ruleDataUtils.ALERT_UUID]) || '',
    index: '.internal.alerts-observability.metrics.alerts-*',
    rule: {
      id: rule.id,
      name: rule.name
    },
    type: _common.AttachmentType.alert
  }] : [];
  const handleAddToCase = () => {
    setIsPopoverOpen(false);
    selectCaseModal.open({
      getAttachments: () => attachments
    });
  };
  const handleViewRuleDetails = () => {
    setIsPopoverOpen(false);
    setRuleConditionsFlyoutOpen(true);
  };
  const handleOpenSnoozeModal = () => {
    setIsPopoverOpen(false);
    setSnoozeModalOpen(true);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: handleClosePopover,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "arrowDown",
      iconSide: "right",
      onClick: handleTogglePopover,
      "data-test-subj": "alert-details-header-actions-menu-button"
    }, _i18n.i18n.translate('xpack.observability.alertDetails.actionsButtonLabel', {
      defaultMessage: 'Actions'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    disabled: !(alert !== null && alert !== void 0 && alert.fields[_ruleDataUtils.ALERT_RULE_UUID]) || !rule,
    onClick: handleViewRuleDetails,
    "data-test-subj": "view-rule-details-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.viewRuleDetails', {
    defaultMessage: 'View rule details'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    onClick: handleOpenSnoozeModal,
    "data-test-subj": "snooze-rule-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.editSnoozeRule', {
    defaultMessage: 'Snooze the rule'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "s",
    color: "text",
    onClick: handleAddToCase,
    "data-test-subj": "add-to-case-button"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.observability.alertDetails.addToCase', {
    defaultMessage: 'Add to case'
  }))))), rule && ruleConditionsFlyoutOpen ? /*#__PURE__*/_react.default.createElement(EditRuleFlyout, {
    initialRule: rule,
    onClose: () => {
      setRuleConditionsFlyoutOpen(false);
    },
    onSave: async () => {
      refetch();
    }
  }) : null, rule && snoozeModalOpen ? /*#__PURE__*/_react.default.createElement(RuleSnoozeModal, {
    rule: rule,
    onClose: () => setSnoozeModalOpen(false),
    onRuleChanged: async () => {
      refetch();
    },
    onLoading: _lodash.noop
  }) : null);
}