"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFilteredRuleTypes = useGetFilteredRuleTypes;
var _react = require("react");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _use_plugin_context = require("./use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGetFilteredRuleTypes() {
  const {
    observabilityRuleTypeRegistry
  } = (0, _use_plugin_context.usePluginContext)();
  return (0, _react.useMemo)(() => {
    return [_ruleDataUtils.ES_QUERY_ID, ...observabilityRuleTypeRegistry.list()];
  }, [observabilityRuleTypeRegistry]);
}