"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchIndices = useFetchIndices;
var _reactQuery = require("@tanstack/react-query");
var _kibana_react = require("../utils/kibana_react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useFetchIndices({
  search
}) {
  const {
    http
  } = (0, _kibana_react.useKibana)().services;
  const {
    isLoading,
    isError,
    isSuccess,
    data
  } = (0, _reactQuery.useQuery)({
    queryKey: ['fetchIndices', search],
    queryFn: async () => {
      const searchPattern = search !== null && search !== void 0 && search.endsWith('*') ? search : `${search}*`;
      const response = await http.get(`/internal/index-pattern-management/resolve_index/${searchPattern}`);
      return response.indices.map(index => index.name);
    },
    retry: false,
    enabled: Boolean(search),
    refetchOnWindowFocus: false,
    keepPreviousData: true
  });
  return {
    isLoading,
    isError,
    isSuccess,
    data
  };
}