"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUpdateSlo = useUpdateSlo;
var _i18n = require("@kbn/i18n");
var _reactQuery = require("@tanstack/react-query");
var _rison = require("@kbn/rison");
var _kibana_react = require("../../utils/kibana_react");
var _paths = require("../../../common/locators/paths");
var _query_key_factory = require("./query_key_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUpdateSlo() {
  const {
    application: {
      navigateToUrl
    },
    http,
    notifications: {
      toasts
    }
  } = (0, _kibana_react.useKibana)().services;
  const queryClient = (0, _reactQuery.useQueryClient)();
  return (0, _reactQuery.useMutation)(['updateSlo'], ({
    sloId,
    slo
  }) => {
    const body = JSON.stringify(slo);
    return http.put(`/api/observability/slos/${sloId}`, {
      body
    });
  }, {
    onMutate: async ({
      sloId,
      slo
    }) => {
      var _queriesData$at, _previousData$page, _previousData$perPage, _previousData$results, _previousData$results2;
      await queryClient.cancelQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      const queriesData = queryClient.getQueriesData({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
      const [queryKey, previousData] = (_queriesData$at = queriesData === null || queriesData === void 0 ? void 0 : queriesData.at(0)) !== null && _queriesData$at !== void 0 ? _queriesData$at : [];
      const updatedItem = {
        ...slo,
        id: sloId
      };
      const optimisticUpdate = {
        page: (_previousData$page = previousData === null || previousData === void 0 ? void 0 : previousData.page) !== null && _previousData$page !== void 0 ? _previousData$page : 1,
        perPage: (_previousData$perPage = previousData === null || previousData === void 0 ? void 0 : previousData.perPage) !== null && _previousData$perPage !== void 0 ? _previousData$perPage : 25,
        total: previousData !== null && previousData !== void 0 && previousData.total ? previousData.total : 1,
        results: [...((_previousData$results = previousData === null || previousData === void 0 ? void 0 : (_previousData$results2 = previousData.results) === null || _previousData$results2 === void 0 ? void 0 : _previousData$results2.filter(result => result.id !== sloId)) !== null && _previousData$results !== void 0 ? _previousData$results : []), updatedItem]
      };
      if (queryKey) {
        queryClient.setQueryData(queryKey, optimisticUpdate);
      }
      return {
        previousData,
        queryKey,
        sloId
      };
    },
    onSuccess: (_data, {
      slo: {
        name
      }
    }) => {
      toasts.addSuccess(_i18n.i18n.translate('xpack.observability.slo.update.successNotification', {
        defaultMessage: 'Successfully updated {name}',
        values: {
          name
        }
      }));
      queryClient.invalidateQueries({
        queryKey: _query_key_factory.sloKeys.lists(),
        exact: false
      });
    },
    onError: (error, {
      slo
    }, context) => {
      var _error$body$message, _error$body;
      if (context !== null && context !== void 0 && context.previousData && context !== null && context !== void 0 && context.queryKey) {
        queryClient.setQueryData(context.queryKey, context.previousData);
      }
      toasts.addError(new Error((_error$body$message = (_error$body = error.body) === null || _error$body === void 0 ? void 0 : _error$body.message) !== null && _error$body$message !== void 0 ? _error$body$message : error.message), {
        title: _i18n.i18n.translate('xpack.observability.slo.update.errorNotification', {
          defaultMessage: 'Something went wrong when updating {name}',
          values: {
            name: slo.name
          }
        })
      });
      if (context !== null && context !== void 0 && context.sloId) {
        navigateToUrl(http.basePath.prepend(_paths.paths.observability.sloEditWithEncodedForm(context.sloId, (0, _rison.encode)(slo))));
      }
    }
  });
}