"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActiveAlerts = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ActiveAlerts {
  constructor(initialData) {
    (0, _defineProperty2.default)(this, "data", new Map());
    if (initialData) {
      Object.keys(initialData).forEach(key => this.data.set(key, initialData[key]));
    }
  }
  set(slo, value) {
    var _slo$instanceId;
    this.data.set(`${slo.id}|${(_slo$instanceId = slo.instanceId) !== null && _slo$instanceId !== void 0 ? _slo$instanceId : _sloSchema.ALL_VALUE}`, value);
  }
  get(slo) {
    var _slo$instanceId2;
    return this.data.get(`${slo.id}|${(_slo$instanceId2 = slo.instanceId) !== null && _slo$instanceId2 !== void 0 ? _slo$instanceId2 : _sloSchema.ALL_VALUE}`);
  }
  has(slo) {
    var _slo$instanceId3;
    return this.data.has(`${slo.id}|${(_slo$instanceId3 = slo.instanceId) !== null && _slo$instanceId3 !== void 0 ? _slo$instanceId3 : _sloSchema.ALL_VALUE}`);
  }
  delete(slo) {
    var _slo$instanceId4;
    return this.data.delete(`${slo.id}|${(_slo$instanceId4 = slo.instanceId) !== null && _slo$instanceId4 !== void 0 ? _slo$instanceId4 : _sloSchema.ALL_VALUE}`);
  }
  clear() {
    return this.data.clear();
  }
}
exports.ActiveAlerts = ActiveAlerts;