"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useFetchDataViews = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useFetchDataViews = () => {
  return {
    isLoading: false,
    isError: false,
    isSuccess: true,
    data: Array(20).fill(0).map((_, i) => ({
      title: `dataview-${i}`,
      type: 'foo',
      getName: () => `dataview-${i}`,
      getIndexPattern: () => `.index-pattern-dataview-${i}`
    }))
  };
};
exports.useFetchDataViews = useFetchDataViews;