"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloOverviewEmbeddableFactoryDefinition = exports.COMMON_SLO_GROUPING = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _slo_embeddable = require("./slo_embeddable");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
const COMMON_SLO_GROUPING = [{
  id: 'slos',
  getDisplayName: () => 'SLOs',
  getIconType: () => {
    return 'visGauge';
  }
}];
exports.COMMON_SLO_GROUPING = COMMON_SLO_GROUPING;
class SloOverviewEmbeddableFactoryDefinition {
  constructor(getStartServices) {
    (0, _defineProperty2.default)(this, "type", _slo_embeddable.SLO_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "grouping", COMMON_SLO_GROUPING);
    (0, _defineProperty2.default)(this, "getPanelPlacementSettings", () => {
      return {
        width: 12,
        height: 8
      };
    });
    this.getStartServices = getStartServices;
  }
  async isEditable() {
    return true;
  }
  async getExplicitInput() {
    const [coreStart, pluginStart] = await this.getStartServices();
    try {
      const {
        resolveEmbeddableSloUserInput
      } = await Promise.resolve().then(() => _interopRequireWildcard(require('./handle_explicit_input')));
      return await resolveEmbeddableSloUserInput(coreStart, pluginStart);
    } catch (e) {
      return Promise.reject();
    }
  }
  async create(initialInput, parent) {
    try {
      const [{
        uiSettings,
        application,
        http,
        i18n: i18nService
      }] = await this.getStartServices();
      return new _slo_embeddable.SLOEmbeddable({
        uiSettings,
        application,
        http,
        i18n: i18nService
      }, initialInput, parent);
    } catch (e) {
      return new _public.ErrorEmbeddable(e, initialInput, parent);
    }
  }
  getDescription() {
    return _i18n.i18n.translate('xpack.observability.sloEmbeddable.description', {
      defaultMessage: 'Get an overview of your SLO health'
    });
  }
  getDisplayName() {
    return _i18n.i18n.translate('xpack.observability.sloEmbeddable.displayName', {
      defaultMessage: 'SLO Overview'
    });
  }
  getIconType() {
    return 'visGauge';
  }
}
exports.SloOverviewEmbeddableFactoryDefinition = SloOverviewEmbeddableFactoryDefinition;