"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_EMBEDDABLE = exports.SLOEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/embeddable-plugin/public");
var _public2 = require("@kbn/kibana-react-plugin/public");
var _reactQuery = require("@tanstack/react-query");
var _rxjs = require("rxjs");
var _slo_overview = require("./slo_overview");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_EMBEDDABLE = 'SLO_EMBEDDABLE';
exports.SLO_EMBEDDABLE = SLO_EMBEDDABLE;
class SLOEmbeddable extends _public.Embeddable {
  constructor(deps, initialInput, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", SLO_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "reloadSubject", void 0);
    this.deps = deps;
    this.reloadSubject = new _rxjs.Subject();
    this.setTitle(this.input.title || _i18n.i18n.translate('xpack.observability.sloEmbeddable.displayTitle', {
      defaultMessage: 'SLO Overview'
    }));
  }
  setTitle(title) {
    this.updateInput({
      title
    });
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
  }
  render(node) {
    super.render(node);
    this.node = node;
    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const {
      sloId,
      sloInstanceId
    } = this.getInput();
    const queryClient = new _reactQuery.QueryClient();
    const I18nContext = this.deps.i18n.Context;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public2.KibanaContextProvider, {
      services: this.deps
    }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: queryClient
    }, /*#__PURE__*/_react.default.createElement(_slo_overview.SloOverview, {
      onRenderComplete: () => this.onRenderComplete(),
      sloId: sloId,
      sloInstanceId: sloInstanceId,
      reloadSubject: this.reloadSubject
    })))), node);
  }
  reload() {
    this.reloadSubject.next(true);
  }
  destroy() {
    super.destroy();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
}
exports.SLOEmbeddable = SLOEmbeddable;