"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloAlertsWrapper = SloAlertsWrapper;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _slo_alerts_summary = require("./components/slo_alerts_summary");
var _slo_alerts_table = require("./components/slo_alerts_table");
var _edit_slo_alerts_panel = require("../../../ui_actions/edit_slo_alerts_panel");
var _paths = require("../../../../common/locators/paths");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloAlertsWrapper({
  embeddable,
  slos: initialSlos,
  deps,
  timeRange: initialTimeRange,
  onRenderComplete,
  reloadSubject
}) {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = deps;
  const [timeRange, setTimeRange] = (0, _react.useState)(initialTimeRange);
  const [slos, setSlos] = (0, _react.useState)(initialSlos);
  const [lastRefreshTime, setLastRefreshTime] = (0, _react.useState)(undefined);
  (0, _react.useEffect)(() => {
    const subs = reloadSubject === null || reloadSubject === void 0 ? void 0 : reloadSubject.subscribe(input => {
      if (input) {
        const {
          timeRange: nTimeRange,
          slos: nSlos
        } = input;
        setSlos(nSlos);
        if (nTimeRange && (nTimeRange.from !== timeRange.from || nTimeRange.to !== timeRange.to)) {
          setTimeRange(nTimeRange);
        }
      }
      setLastRefreshTime(Date.now());
    });
    return () => {
      subs === null || subs === void 0 ? void 0 : subs.unsubscribe();
    };
  }, [reloadSubject, timeRange.from, timeRange.to]);
  (0, _react.useEffect)(() => {
    setTimeRange(initialTimeRange);
  }, [initialTimeRange]);
  const [isSummaryLoaded, setIsSummaryLoaded] = (0, _react.useState)(false);
  const [isTableLoaded, setIsTableLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!onRenderComplete) {
      return;
    }
    if (isSummaryLoaded && isTableLoaded) {
      onRenderComplete();
    }
  }, [isSummaryLoaded, isTableLoaded, onRenderComplete]);
  const handleGoToAlertsClick = () => {
    let kuery = '';
    slos.map((slo, index) => {
      const shouldAddOr = index < slos.length - 1;
      kuery += `(slo.id:"${slo.id}" and slo.instanceId:"${slo.instanceId}")`;
      if (shouldAddOr) {
        kuery += ' or ';
      }
    });
    navigateToUrl(`${basePath.prepend(_paths.paths.observability.alerts)}?_a=(kuery:'${kuery}',rangeFrom:${timeRange.from},rangeTo:${timeRange.to})`);
  };
  return /*#__PURE__*/_react.default.createElement(Wrapper, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    wrap: true,
    css: `
          margin: 0 35px;
        `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    onClick: () => {
      const trigger = deps.uiActions.getTrigger(_public.CONTEXT_MENU_TRIGGER);
      deps.uiActions.getAction(_edit_slo_alerts_panel.EDIT_SLO_ALERTS_ACTION).execute({
        trigger,
        embeddable
      });
    },
    "data-test-subj": "o11ySloAlertsWrapperSlOsIncludedLink"
  }, _i18n.i18n.translate('xpack.observability.sloAlertsWrapper.sLOsIncludedFlexItemLabel', {
    defaultMessage: '{numOfSlos} SLOs included',
    values: {
      numOfSlos: slos.length
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "o11ySloAlertsWrapperGoToAlertsLink",
    onClick: handleGoToAlertsClick
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.sloAlertsWrapper.goToAlertsFlexItemLabel",
    defaultMessage: "Go to alerts"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    style: {
      margin: '10px'
    },
    responsive: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_slo_alerts_summary.SloAlertsSummary, {
    slos: slos,
    deps: deps,
    timeRange: timeRange,
    onLoaded: () => setIsSummaryLoaded(true)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_slo_alerts_table.SloAlertsTable, {
    slos: slos,
    deps: deps,
    timeRange: timeRange,
    onLoaded: () => setIsTableLoaded(true),
    lastReloadRequestTime: lastRefreshTime
  }))));
}
const Wrapper = _styledComponents.default.div`
  width: 100%;
`;