"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SLO_ALERTS_EMBEDDABLE = exports.SLOAlertsEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactQuery = require("@tanstack/react-query");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-utils-plugin/public");
var _history = require("history");
var _public2 = require("@kbn/embeddable-plugin/public");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _rxjs = require("rxjs");
var _slo_alerts_wrapper = require("./slo_alerts_wrapper");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_ALERTS_EMBEDDABLE = 'SLO_ALERTS_EMBEDDABLE';
exports.SLO_ALERTS_EMBEDDABLE = SLO_ALERTS_EMBEDDABLE;
const history = (0, _history.createBrowserHistory)();
class SLOAlertsEmbeddable extends _public2.Embeddable {
  constructor(deps, initialInput, kibanaVersion, parent) {
    super(initialInput, {}, parent);
    (0, _defineProperty2.default)(this, "type", SLO_ALERTS_EMBEDDABLE);
    (0, _defineProperty2.default)(this, "reloadSubject", void 0);
    (0, _defineProperty2.default)(this, "node", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    this.deps = deps;
    this.deps = deps;
    this.kibanaVersion = kibanaVersion;
    this.reloadSubject = new _rxjs.Subject();
    this.subscription = this.getInput$().subscribe(input => {
      this.reloadSubject.next(input);
    });
    this.setTitle(this.input.title || _i18n.i18n.translate('xpack.observability.sloAlertsEmbeddable.displayTitle', {
      defaultMessage: 'SLO Alerts'
    }));
  }
  onRenderComplete() {
    this.renderComplete.dispatchComplete();
  }
  setTitle(title) {
    this.updateInput({
      title
    });
  }
  render(node) {
    super.render(node);
    this.node = node;
    // required for the export feature to work
    this.node.setAttribute('data-shared-item', '');
    const queryClient = new _reactQuery.QueryClient();
    const I18nContext = this.deps.i18n.Context;
    const {
      slos,
      timeRange = {
        from: 'now-15m/m',
        to: 'now'
      }
    } = this.getInput();
    const deps = this.deps;
    const kibanaVersion = this.kibanaVersion;
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(I18nContext, null, /*#__PURE__*/_react.default.createElement(_public3.KibanaContextProvider, {
      services: {
        ...this.deps,
        storage: new _public.Storage(localStorage),
        isServerless: !!deps.serverless,
        kibanaVersion
      }
    }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
      history: history
    }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
      client: queryClient
    }, /*#__PURE__*/_react.default.createElement(_slo_alerts_wrapper.SloAlertsWrapper, {
      onRenderComplete: () => this.onRenderComplete(),
      embeddable: this,
      deps: deps,
      slos: slos,
      timeRange: timeRange,
      reloadSubject: this.reloadSubject
    }))))), node);
  }
  reload() {
    var _this$reloadSubject;
    (_this$reloadSubject = this.reloadSubject) === null || _this$reloadSubject === void 0 ? void 0 : _this$reloadSubject.next(undefined);
  }
  destroy() {
    super.destroy();
    this.subscription.unsubscribe();
    if (this.node) {
      _reactDom.default.unmountComponentAtNode(this.node);
    }
  }
}
exports.SLOAlertsEmbeddable = SLOAlertsEmbeddable;