"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.historicalSummaryData = exports.SLO_NO_DATA = exports.NO_DATA_TO_HEALTHY_ROLLING_SLO = exports.HEALTHY_STEP_DOWN_ROLLING_SLO = exports.HEALTHY_ROLLING_SLO = exports.HEALTHY_RANDOM_ROLLING_SLO = exports.DEGRADING_FAST_ROLLING_SLO = void 0;
var _sloSchema = require("@kbn/slo-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SLO_NO_DATA = 'SLO_NO_DATA';
exports.SLO_NO_DATA = SLO_NO_DATA;
const NO_DATA_TO_HEALTHY_ROLLING_SLO = 'NO_DATA_TO_HEALTHY_ROLLING_SLO';
exports.NO_DATA_TO_HEALTHY_ROLLING_SLO = NO_DATA_TO_HEALTHY_ROLLING_SLO;
const HEALTHY_ROLLING_SLO = 'HEALTHY_ROLLING_SLO';
exports.HEALTHY_ROLLING_SLO = HEALTHY_ROLLING_SLO;
const HEALTHY_RANDOM_ROLLING_SLO = 'HEALTHY_RANDOM_ROLLING_SLO';
exports.HEALTHY_RANDOM_ROLLING_SLO = HEALTHY_RANDOM_ROLLING_SLO;
const HEALTHY_STEP_DOWN_ROLLING_SLO = 'HEALTHY_STEP_DOWN_ROLLING_SLO';
exports.HEALTHY_STEP_DOWN_ROLLING_SLO = HEALTHY_STEP_DOWN_ROLLING_SLO;
const DEGRADING_FAST_ROLLING_SLO = 'DEGRADING_FAST_ROLLING_SLO';
exports.DEGRADING_FAST_ROLLING_SLO = DEGRADING_FAST_ROLLING_SLO;
const historicalSummaryData = [{
  sloId: SLO_NO_DATA,
  instanceId: _sloSchema.ALL_VALUE,
  data: []
}, {
  sloId: NO_DATA_TO_HEALTHY_ROLLING_SLO,
  instanceId: _sloSchema.ALL_VALUE,
  data: [{
    date: '2022-12-20T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-21T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-22T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-23T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-24T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-25T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-26T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-27T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-28T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: -1,
    status: 'NO_DATA'
  }, {
    date: '2022-12-29T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.1,
      remaining: 0.9,
      isEstimated: false
    },
    sliValue: 0.995,
    status: 'HEALTHY'
  }, {
    date: '2022-12-30T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-31T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.3,
      remaining: 0.7,
      isEstimated: false
    },
    sliValue: 0.985,
    status: 'HEALTHY'
  }, {
    date: '2023-01-01T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.4,
      remaining: 0.6,
      isEstimated: false
    },
    sliValue: 0.98,
    status: 'HEALTHY'
  }, {
    date: '2023-01-02T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.5,
      remaining: 0.5,
      isEstimated: false
    },
    sliValue: 0.975,
    status: 'HEALTHY'
  }, {
    date: '2023-01-03T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.6,
      remaining: 0.4,
      isEstimated: false
    },
    sliValue: 0.97,
    status: 'HEALTHY'
  }, {
    date: '2023-01-04T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.7,
      remaining: 0.3,
      isEstimated: false
    },
    sliValue: 0.965,
    status: 'HEALTHY'
  }, {
    date: '2023-01-05T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.8,
      remaining: 0.2,
      isEstimated: false
    },
    sliValue: 0.96,
    status: 'HEALTHY'
  }, {
    date: '2023-01-06T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.9,
      remaining: 0.1,
      isEstimated: false
    },
    sliValue: 0.955,
    status: 'HEALTHY'
  }, {
    date: '2023-01-07T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1,
      remaining: 0,
      isEstimated: false
    },
    sliValue: 0.95,
    status: 'HEALTHY'
  }, {
    date: '2023-01-08T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.1,
      remaining: -0.1,
      isEstimated: false
    },
    sliValue: 0.945,
    status: 'VIOLATED'
  }, {
    date: '2023-01-09T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.2,
      remaining: -0.2,
      isEstimated: false
    },
    sliValue: 0.94,
    status: 'VIOLATED'
  }, {
    date: '2023-01-10T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.3,
      remaining: -0.3,
      isEstimated: false
    },
    sliValue: 0.935,
    status: 'VIOLATED'
  }, {
    date: '2023-01-11T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.4,
      remaining: -0.4,
      isEstimated: false
    },
    sliValue: 0.93,
    status: 'VIOLATED'
  }, {
    date: '2023-01-12T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.5,
      remaining: -0.5,
      isEstimated: false
    },
    sliValue: 0.925,
    status: 'VIOLATED'
  }, {
    date: '2023-01-13T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.6,
      remaining: -0.6,
      isEstimated: false
    },
    sliValue: 0.92,
    status: 'VIOLATED'
  }, {
    date: '2023-01-14T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.7,
      remaining: -0.7,
      isEstimated: false
    },
    sliValue: 0.915,
    status: 'VIOLATED'
  }, {
    date: '2023-01-15T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.8,
      remaining: -0.8,
      isEstimated: false
    },
    sliValue: 0.91,
    status: 'VIOLATED'
  }, {
    date: '2023-01-16T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.9,
      remaining: -0.9,
      isEstimated: false
    },
    sliValue: 0.905,
    status: 'VIOLATED'
  }, {
    date: '2023-01-17T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 2,
      remaining: -1,
      isEstimated: false
    },
    sliValue: 0.9,
    status: 'VIOLATED'
  }, {
    date: '2023-01-18T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 2.1,
      remaining: -1.1,
      isEstimated: false
    },
    sliValue: 0.895,
    status: 'VIOLATED'
  }, {
    date: '2023-01-19T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 2.2,
      remaining: -1.2,
      isEstimated: false
    },
    sliValue: 0.89,
    status: 'VIOLATED'
  }]
}, {
  sloId: HEALTHY_ROLLING_SLO,
  instanceId: _sloSchema.ALL_VALUE,
  data: [{
    date: '2022-12-20T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-21T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-22T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-23T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-24T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-25T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-26T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-27T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-28T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-29T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-30T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-31T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-01T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-02T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-03T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-04T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-05T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-06T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-07T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-08T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-09T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-10T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-11T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-12T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-13T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-14T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-15T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-16T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-17T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-18T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2023-01-19T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }]
}, {
  sloId: HEALTHY_RANDOM_ROLLING_SLO,
  instanceId: _sloSchema.ALL_VALUE,
  data: [{
    date: '2022-12-20T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.792412,
      remaining: 0.207588,
      isEstimated: false
    },
    sliValue: 0.960379,
    status: 'HEALTHY'
  }, {
    date: '2022-12-21T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.956593,
      remaining: 0.043407,
      isEstimated: false
    },
    sliValue: 0.95217,
    status: 'HEALTHY'
  }, {
    date: '2022-12-22T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.579858,
      remaining: 0.420142,
      isEstimated: false
    },
    sliValue: 0.971007,
    status: 'HEALTHY'
  }, {
    date: '2022-12-23T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.248975,
      remaining: 0.751025,
      isEstimated: false
    },
    sliValue: 0.987551,
    status: 'HEALTHY'
  }, {
    date: '2022-12-24T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.569716,
      remaining: 0.430284,
      isEstimated: false
    },
    sliValue: 0.971514,
    status: 'HEALTHY'
  }, {
    date: '2022-12-25T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.271077,
      remaining: 0.728923,
      isEstimated: false
    },
    sliValue: 0.986446,
    status: 'HEALTHY'
  }, {
    date: '2022-12-26T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.199903,
      remaining: 0.800097,
      isEstimated: false
    },
    sliValue: 0.990005,
    status: 'HEALTHY'
  }, {
    date: '2022-12-27T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.879368,
      remaining: 0.120632,
      isEstimated: false
    },
    sliValue: 0.956032,
    status: 'HEALTHY'
  }, {
    date: '2022-12-28T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.408721,
      remaining: 0.591279,
      isEstimated: false
    },
    sliValue: 0.979564,
    status: 'HEALTHY'
  }, {
    date: '2022-12-29T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.684045,
      remaining: 0.315955,
      isEstimated: false
    },
    sliValue: 0.965798,
    status: 'HEALTHY'
  }, {
    date: '2022-12-30T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.014247,
      remaining: 0.985753,
      isEstimated: false
    },
    sliValue: 0.999288,
    status: 'HEALTHY'
  }, {
    date: '2022-12-31T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.528067,
      remaining: 0.471933,
      isEstimated: false
    },
    sliValue: 0.973597,
    status: 'HEALTHY'
  }, {
    date: '2023-01-01T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.168269,
      remaining: 0.831731,
      isEstimated: false
    },
    sliValue: 0.991587,
    status: 'HEALTHY'
  }, {
    date: '2023-01-02T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.562795,
      remaining: 0.437205,
      isEstimated: false
    },
    sliValue: 0.97186,
    status: 'HEALTHY'
  }, {
    date: '2023-01-03T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.226658,
      remaining: 0.773342,
      isEstimated: false
    },
    sliValue: 0.988667,
    status: 'HEALTHY'
  }, {
    date: '2023-01-04T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.723373,
      remaining: 0.276627,
      isEstimated: false
    },
    sliValue: 0.963831,
    status: 'HEALTHY'
  }, {
    date: '2023-01-05T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.296797,
      remaining: 0.703203,
      isEstimated: false
    },
    sliValue: 0.98516,
    status: 'HEALTHY'
  }, {
    date: '2023-01-06T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.90246,
      remaining: 0.09754,
      isEstimated: false
    },
    sliValue: 0.954877,
    status: 'HEALTHY'
  }, {
    date: '2023-01-07T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.561973,
      remaining: 0.438027,
      isEstimated: false
    },
    sliValue: 0.971901,
    status: 'HEALTHY'
  }, {
    date: '2023-01-08T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.370939,
      remaining: 0.629061,
      isEstimated: false
    },
    sliValue: 0.981453,
    status: 'HEALTHY'
  }, {
    date: '2023-01-09T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.636337,
      remaining: 0.363663,
      isEstimated: false
    },
    sliValue: 0.968183,
    status: 'HEALTHY'
  }, {
    date: '2023-01-10T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.99534,
      remaining: 0.00466,
      isEstimated: false
    },
    sliValue: 0.950233,
    status: 'HEALTHY'
  }, {
    date: '2023-01-11T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.493501,
      remaining: 0.506499,
      isEstimated: false
    },
    sliValue: 0.975325,
    status: 'HEALTHY'
  }, {
    date: '2023-01-12T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.666628,
      remaining: 0.333372,
      isEstimated: false
    },
    sliValue: 0.966669,
    status: 'HEALTHY'
  }, {
    date: '2023-01-13T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.708286,
      remaining: 0.291714,
      isEstimated: false
    },
    sliValue: 0.964586,
    status: 'HEALTHY'
  }, {
    date: '2023-01-14T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.361611,
      remaining: 0.638389,
      isEstimated: false
    },
    sliValue: 0.981919,
    status: 'HEALTHY'
  }, {
    date: '2023-01-15T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.883103,
      remaining: 0.116897,
      isEstimated: false
    },
    sliValue: 0.955845,
    status: 'HEALTHY'
  }, {
    date: '2023-01-16T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.104661,
      remaining: 0.895339,
      isEstimated: false
    },
    sliValue: 0.994767,
    status: 'HEALTHY'
  }, {
    date: '2023-01-17T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.008557,
      remaining: 0.991443,
      isEstimated: false
    },
    sliValue: 0.999572,
    status: 'HEALTHY'
  }, {
    date: '2023-01-18T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.450975,
      remaining: 0.549025,
      isEstimated: false
    },
    sliValue: 0.977451,
    status: 'HEALTHY'
  }, {
    date: '2023-01-19T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.145818,
      remaining: 0.854182,
      isEstimated: false
    },
    sliValue: 0.992709,
    status: 'HEALTHY'
  }]
}, {
  sloId: HEALTHY_STEP_DOWN_ROLLING_SLO,
  instanceId: _sloSchema.ALL_VALUE,
  data: [{
    date: '2022-12-20T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: 1,
    status: 'HEALTHY'
  }, {
    date: '2022-12-21T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: 1,
    status: 'HEALTHY'
  }, {
    date: '2022-12-22T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0,
      remaining: 1,
      isEstimated: false
    },
    sliValue: 1,
    status: 'HEALTHY'
  }, {
    date: '2022-12-23T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.1,
      remaining: 0.9,
      isEstimated: false
    },
    sliValue: 0.995,
    status: 'HEALTHY'
  }, {
    date: '2022-12-24T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.1,
      remaining: 0.9,
      isEstimated: false
    },
    sliValue: 0.995,
    status: 'HEALTHY'
  }, {
    date: '2022-12-25T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.1,
      remaining: 0.9,
      isEstimated: false
    },
    sliValue: 0.995,
    status: 'HEALTHY'
  }, {
    date: '2022-12-26T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.1,
      remaining: 0.9,
      isEstimated: false
    },
    sliValue: 0.995,
    status: 'HEALTHY'
  }, {
    date: '2022-12-27T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-28T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-29T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-30T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.2,
      remaining: 0.8,
      isEstimated: false
    },
    sliValue: 0.99,
    status: 'HEALTHY'
  }, {
    date: '2022-12-31T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.3,
      remaining: 0.7,
      isEstimated: false
    },
    sliValue: 0.985,
    status: 'HEALTHY'
  }, {
    date: '2023-01-01T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.3,
      remaining: 0.7,
      isEstimated: false
    },
    sliValue: 0.985,
    status: 'HEALTHY'
  }, {
    date: '2023-01-02T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.3,
      remaining: 0.7,
      isEstimated: false
    },
    sliValue: 0.985,
    status: 'HEALTHY'
  }, {
    date: '2023-01-03T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.3,
      remaining: 0.7,
      isEstimated: false
    },
    sliValue: 0.985,
    status: 'HEALTHY'
  }, {
    date: '2023-01-04T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.4,
      remaining: 0.6,
      isEstimated: false
    },
    sliValue: 0.98,
    status: 'HEALTHY'
  }, {
    date: '2023-01-05T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.4,
      remaining: 0.6,
      isEstimated: false
    },
    sliValue: 0.98,
    status: 'HEALTHY'
  }, {
    date: '2023-01-06T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.4,
      remaining: 0.6,
      isEstimated: false
    },
    sliValue: 0.98,
    status: 'HEALTHY'
  }, {
    date: '2023-01-07T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.4,
      remaining: 0.6,
      isEstimated: false
    },
    sliValue: 0.98,
    status: 'HEALTHY'
  }, {
    date: '2023-01-08T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.5,
      remaining: 0.5,
      isEstimated: false
    },
    sliValue: 0.975,
    status: 'HEALTHY'
  }, {
    date: '2023-01-09T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.5,
      remaining: 0.5,
      isEstimated: false
    },
    sliValue: 0.975,
    status: 'HEALTHY'
  }, {
    date: '2023-01-10T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.5,
      remaining: 0.5,
      isEstimated: false
    },
    sliValue: 0.975,
    status: 'HEALTHY'
  }, {
    date: '2023-01-11T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.5,
      remaining: 0.5,
      isEstimated: false
    },
    sliValue: 0.975,
    status: 'HEALTHY'
  }, {
    date: '2023-01-12T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.6,
      remaining: 0.4,
      isEstimated: false
    },
    sliValue: 0.97,
    status: 'HEALTHY'
  }, {
    date: '2023-01-13T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.6,
      remaining: 0.4,
      isEstimated: false
    },
    sliValue: 0.97,
    status: 'HEALTHY'
  }, {
    date: '2023-01-14T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.6,
      remaining: 0.4,
      isEstimated: false
    },
    sliValue: 0.97,
    status: 'HEALTHY'
  }, {
    date: '2023-01-15T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.6,
      remaining: 0.4,
      isEstimated: false
    },
    sliValue: 0.97,
    status: 'HEALTHY'
  }, {
    date: '2023-01-16T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.7,
      remaining: 0.3,
      isEstimated: false
    },
    sliValue: 0.965,
    status: 'HEALTHY'
  }, {
    date: '2023-01-17T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.7,
      remaining: 0.3,
      isEstimated: false
    },
    sliValue: 0.965,
    status: 'HEALTHY'
  }, {
    date: '2023-01-18T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.7,
      remaining: 0.3,
      isEstimated: false
    },
    sliValue: 0.965,
    status: 'HEALTHY'
  }, {
    date: '2023-01-19T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.7,
      remaining: 0.3,
      isEstimated: false
    },
    sliValue: 0.965,
    status: 'HEALTHY'
  }]
}, {
  sloId: DEGRADING_FAST_ROLLING_SLO,
  instanceId: _sloSchema.ALL_VALUE,
  data: [{
    date: '2022-12-20T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.06,
      remaining: 0.94,
      isEstimated: false
    },
    sliValue: 0.997,
    status: 'HEALTHY'
  }, {
    date: '2022-12-21T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.12,
      remaining: 0.88,
      isEstimated: false
    },
    sliValue: 0.994,
    status: 'HEALTHY'
  }, {
    date: '2022-12-22T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.18,
      remaining: 0.82,
      isEstimated: false
    },
    sliValue: 0.991,
    status: 'HEALTHY'
  }, {
    date: '2022-12-23T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.24,
      remaining: 0.76,
      isEstimated: false
    },
    sliValue: 0.988,
    status: 'HEALTHY'
  }, {
    date: '2022-12-24T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.3,
      remaining: 0.7,
      isEstimated: false
    },
    sliValue: 0.985,
    status: 'HEALTHY'
  }, {
    date: '2022-12-25T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.36,
      remaining: 0.64,
      isEstimated: false
    },
    sliValue: 0.982,
    status: 'HEALTHY'
  }, {
    date: '2022-12-26T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.42,
      remaining: 0.58,
      isEstimated: false
    },
    sliValue: 0.979,
    status: 'HEALTHY'
  }, {
    date: '2022-12-27T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.48,
      remaining: 0.52,
      isEstimated: false
    },
    sliValue: 0.976,
    status: 'HEALTHY'
  }, {
    date: '2022-12-28T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.54,
      remaining: 0.46,
      isEstimated: false
    },
    sliValue: 0.973,
    status: 'HEALTHY'
  }, {
    date: '2022-12-29T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.6,
      remaining: 0.4,
      isEstimated: false
    },
    sliValue: 0.97,
    status: 'HEALTHY'
  }, {
    date: '2022-12-30T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.66,
      remaining: 0.34,
      isEstimated: false
    },
    sliValue: 0.967,
    status: 'HEALTHY'
  }, {
    date: '2022-12-31T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.72,
      remaining: 0.28,
      isEstimated: false
    },
    sliValue: 0.964,
    status: 'HEALTHY'
  }, {
    date: '2023-01-01T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.78,
      remaining: 0.22,
      isEstimated: false
    },
    sliValue: 0.961,
    status: 'HEALTHY'
  }, {
    date: '2023-01-02T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.84,
      remaining: 0.16,
      isEstimated: false
    },
    sliValue: 0.958,
    status: 'HEALTHY'
  }, {
    date: '2023-01-03T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.9,
      remaining: 0.1,
      isEstimated: false
    },
    sliValue: 0.955,
    status: 'HEALTHY'
  }, {
    date: '2023-01-04T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 0.96,
      remaining: 0.04,
      isEstimated: false
    },
    sliValue: 0.952,
    status: 'HEALTHY'
  }, {
    date: '2023-01-05T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.02,
      remaining: -0.02,
      isEstimated: false
    },
    sliValue: 0.949,
    status: 'VIOLATED'
  }, {
    date: '2023-01-06T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.08,
      remaining: -0.08,
      isEstimated: false
    },
    sliValue: 0.946,
    status: 'VIOLATED'
  }, {
    date: '2023-01-07T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.14,
      remaining: -0.14,
      isEstimated: false
    },
    sliValue: 0.943,
    status: 'VIOLATED'
  }, {
    date: '2023-01-08T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.2,
      remaining: -0.2,
      isEstimated: false
    },
    sliValue: 0.94,
    status: 'VIOLATED'
  }, {
    date: '2023-01-09T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.26,
      remaining: -0.26,
      isEstimated: false
    },
    sliValue: 0.937,
    status: 'VIOLATED'
  }, {
    date: '2023-01-10T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.32,
      remaining: -0.32,
      isEstimated: false
    },
    sliValue: 0.934,
    status: 'VIOLATED'
  }, {
    date: '2023-01-11T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.38,
      remaining: -0.38,
      isEstimated: false
    },
    sliValue: 0.931,
    status: 'VIOLATED'
  }, {
    date: '2023-01-12T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.44,
      remaining: -0.44,
      isEstimated: false
    },
    sliValue: 0.928,
    status: 'VIOLATED'
  }, {
    date: '2023-01-13T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.5,
      remaining: -0.5,
      isEstimated: false
    },
    sliValue: 0.925,
    status: 'VIOLATED'
  }, {
    date: '2023-01-14T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.56,
      remaining: -0.56,
      isEstimated: false
    },
    sliValue: 0.922,
    status: 'VIOLATED'
  }, {
    date: '2023-01-15T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.62,
      remaining: -0.62,
      isEstimated: false
    },
    sliValue: 0.919,
    status: 'VIOLATED'
  }, {
    date: '2023-01-16T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.68,
      remaining: -0.68,
      isEstimated: false
    },
    sliValue: 0.916,
    status: 'VIOLATED'
  }, {
    date: '2023-01-17T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.74,
      remaining: -0.74,
      isEstimated: false
    },
    sliValue: 0.913,
    status: 'VIOLATED'
  }, {
    date: '2023-01-18T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.8,
      remaining: -0.8,
      isEstimated: false
    },
    sliValue: 0.91,
    status: 'VIOLATED'
  }, {
    date: '2023-01-19T00:00:00.000Z',
    errorBudget: {
      initial: 0.05,
      consumed: 1.86,
      remaining: -0.86,
      isEstimated: false
    },
    sliValue: 0.907,
    status: 'VIOLATED'
  }]
}];
exports.historicalSummaryData = historicalSummaryData;