"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SloOutdatedCallout = SloOutdatedCallout;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _use_fetch_slo_definitions = require("../../../hooks/slo/use_fetch_slo_definitions");
var _kibana_react = require("../../../utils/kibana_react");
var _paths = require("../../../../common/locators/paths");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SloOutdatedCallout() {
  const {
    application: {
      navigateToUrl
    },
    http: {
      basePath
    }
  } = (0, _kibana_react.useKibana)().services;
  const handleClick = () => {
    navigateToUrl(basePath.prepend(_paths.paths.observability.slosOutdatedDefinitions));
  };
  const {
    isLoading,
    data
  } = (0, _use_fetch_slo_definitions.useFetchSloDefinitions)({
    includeOutdatedOnly: true
  });
  if (!isLoading && data && data.total > 0) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "warning",
      iconType: "warning",
      title: _i18n.i18n.translate('xpack.observability.slo.outdatedSloCallout.title', {
        defaultMessage: '{total} Outdated SLOs Detected',
        values: {
          total: data.total
        }
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.slo.outdatedSloCallout.message",
      defaultMessage: "We've noticed that you have {total} outdated SLO definitions, these SLOs will not be running or alerting until you've reset them. Please click the button below to review the SLO definitions; you can choose to either reset the SLO definition or remove it.",
      values: {
        total: data.total
      }
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "warning",
      "data-test-subj": "o11ySloOutdatedCalloutViewOutdatedSloDefinitionsButton",
      fill: true,
      onClick: handleClick
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.outdatedSloCallout.buttonLabel",
      defaultMessage: "Review Outdated SLO Definitions"
    }))));
  }
  return null;
}