"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SuggestionItem = SuggestionItem;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/unified-search-plugin/public");
var _polished = require("polished");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SuggestionItem(props) {
  const {
    isSelected,
    onClick,
    onMouseEnter,
    suggestion
  } = props;
  return /*#__PURE__*/_react.default.createElement(SuggestionItemContainer, {
    isSelected: isSelected,
    onClick: onClick,
    onMouseEnter: onMouseEnter
  }, /*#__PURE__*/_react.default.createElement(SuggestionItemIconField, {
    suggestionType: suggestion.type
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: getEuiIconType(suggestion.type)
  })), /*#__PURE__*/_react.default.createElement(SuggestionItemTextField, null, suggestion.text), /*#__PURE__*/_react.default.createElement(SuggestionItemDescriptionField, null, suggestion.description));
}
SuggestionItem.defaultProps = {
  isSelected: false
};
const SuggestionItemContainer = _common.euiStyled.div`
  display: flex;
  flex-direction: row;
  font-size: ${props => props.theme.eui.euiFontSizeS};
  height: ${props => props.theme.eui.euiSizeXL};
  white-space: nowrap;
  background-color: ${props => props.isSelected ? props.theme.eui.euiColorLightestShade : 'transparent'};
`;
const SuggestionItemField = _common.euiStyled.div`
  align-items: center;
  cursor: pointer;
  display: flex;
  flex-direction: row;
  height: ${props => props.theme.eui.euiSizeXL};
  padding: ${props => props.theme.eui.euiSizeXS};
`;
const SuggestionItemIconField = (0, _common.euiStyled)(SuggestionItemField)`
  background-color: ${props => (0, _polished.transparentize)(0.9, getEuiIconColor(props.theme, props.suggestionType))};
  color: ${props => getEuiIconColor(props.theme, props.suggestionType)};
  flex: 0 0 auto;
  justify-content: center;
  width: ${props => props.theme.eui.euiSizeXL};
`;
const SuggestionItemTextField = (0, _common.euiStyled)(SuggestionItemField)`
  flex: 2 0 0;
  font-family: ${props => props.theme.eui.euiCodeFontFamily};
`;
const SuggestionItemDescriptionField = (0, _common.euiStyled)(SuggestionItemField)`
  flex: 3 0 0;

  p {
    display: inline;

    span {
      font-family: ${props => props.theme.eui.euiCodeFontFamily};
    }
  }
`;
const getEuiIconType = suggestionType => {
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return 'kqlField';
    case _public.QuerySuggestionTypes.Value:
      return 'kqlValue';
    case _public.QuerySuggestionTypes.RecentSearch:
      return 'search';
    case _public.QuerySuggestionTypes.Conjunction:
      return 'kqlSelector';
    case _public.QuerySuggestionTypes.Operator:
      return 'kqlOperand';
    default:
      return 'empty';
  }
};
const getEuiIconColor = (theme, suggestionType) => {
  switch (suggestionType) {
    case _public.QuerySuggestionTypes.Field:
      return theme === null || theme === void 0 ? void 0 : theme.eui.euiColorVis7;
    case _public.QuerySuggestionTypes.Value:
      return theme === null || theme === void 0 ? void 0 : theme.eui.euiColorVis0;
    case _public.QuerySuggestionTypes.Operator:
      return theme === null || theme === void 0 ? void 0 : theme.eui.euiColorVis1;
    case _public.QuerySuggestionTypes.Conjunction:
      return theme === null || theme === void 0 ? void 0 : theme.eui.euiColorVis2;
    case _public.QuerySuggestionTypes.RecentSearch:
    default:
      return theme === null || theme === void 0 ? void 0 : theme.eui.euiColorMediumShade;
  }
};