"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PreviewChart = PreviewChart;
exports.getBufferThreshold = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
var _lensEmbeddableUtils = require("@kbn/lens-embeddable-utils");
var _i18n = require("@kbn/i18n");
var _types = require("../../../../../common/custom_threshold_rule/types");
var _kibana_react = require("../../../../utils/kibana_react");
var _painless_tinymath_parser = require("./painless_tinymath_parser");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getOperationTypeFromRuleAggType = aggType => {
  if (aggType === _types.Aggregators.AVERAGE) return 'average';
  if (aggType === _types.Aggregators.CARDINALITY) return 'unique_count';
  return aggType;
};
const getBufferThreshold = threshold => (Math.ceil((threshold || 0) * 1.1 * 100) / 100).toFixed(2).toString();
exports.getBufferThreshold = getBufferThreshold;
function PreviewChart({
  metricExpression,
  dataView,
  filterQuery,
  groupBy,
  error
}) {
  const {
    services: {
      lens
    }
  } = (0, _kibana_react.useKibana)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    metrics,
    timeSize,
    timeUnit,
    threshold,
    comparator,
    equation
  } = metricExpression;
  const [attributes, setAttributes] = (0, _react.useState)();
  const [aggMap, setAggMap] = (0, _react.useState)();
  const [formula, setFormula] = (0, _react.useState)('');
  const [thresholdReferenceLine, setThresholdReferenceLine] = (0, _react.useState)();
  const [chartLoading, setChartLoading] = (0, _react.useState)(false);
  const formulaAsync = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);

  // Handle Lens error
  (0, _react.useEffect)(() => {
    // Lens does not expose or provide a way to check if there is an error in the chart, yet.
    // To work around this, we check if the element with class 'lnsEmbeddedError' is found in the DOM.
    setTimeout(function () {
      const errorDiv = document.querySelector('.lnsEmbeddedError');
      if (errorDiv) {
        const paragraphElements = errorDiv.querySelectorAll('p');
        if (!paragraphElements || paragraphElements.length < 2) return;
        paragraphElements[0].innerText = _i18n.i18n.translate('xpack.observability.customThreshold.rule..charts.error_equation.title', {
          defaultMessage: 'An error occurred while rendering the chart'
        });
        paragraphElements[1].innerText = _i18n.i18n.translate('xpack.observability.customThreshold.rule..charts.error_equation.description', {
          defaultMessage: 'Check the rule equation.'
        });
      }
    });
  }, [chartLoading, attributes]);

  // Build the threshold reference line
  (0, _react.useEffect)(() => {
    var _metrics$0$field;
    if (!threshold) return;
    const refLayers = [];
    const isPercent = Boolean(metrics.length === 1 && ((_metrics$0$field = metrics[0].field) === null || _metrics$0$field === void 0 ? void 0 : _metrics$0$field.endsWith('.pct')));
    const format = {
      id: isPercent ? 'percent' : 'number',
      params: {
        decimals: isPercent ? 0 : 2
      }
    };
    if (comparator === _types.Comparator.OUTSIDE_RANGE || comparator === _types.Comparator.BETWEEN && threshold.length === 2) {
      const refLineStart = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: (threshold[0] || 0).toString(),
          color: euiTheme.colors.danger,
          fill: comparator === _types.Comparator.OUTSIDE_RANGE ? 'below' : 'above',
          format
        }]
      });
      const refLineEnd = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: (threshold[1] || 0).toString(),
          color: euiTheme.colors.danger,
          fill: comparator === _types.Comparator.OUTSIDE_RANGE ? 'above' : 'below',
          format
        }]
      });
      refLayers.push(refLineStart, refLineEnd);
    } else {
      let fill = 'above';
      if (comparator === _types.Comparator.LT || comparator === _types.Comparator.LT_OR_EQ) {
        fill = 'below';
      }
      const thresholdRefLine = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: (threshold[0] || 0).toString(),
          color: euiTheme.colors.danger,
          fill,
          format
        }]
      });
      // A transparent line to add extra buffer at the top of threshold
      const bufferRefLine = new _lensEmbeddableUtils.XYReferenceLinesLayer({
        data: [{
          value: getBufferThreshold(threshold[0]),
          color: 'transparent',
          fill,
          format
        }]
      });
      refLayers.push(thresholdRefLine, bufferRefLine);
    }
    setThresholdReferenceLine(refLayers);
  }, [threshold, comparator, euiTheme.colors.danger, metrics]);

  // Build the aggregation map from the metrics
  (0, _react.useEffect)(() => {
    if (!metrics || metrics.length === 0) {
      return;
    }
    const aggMapFromMetrics = metrics.reduce((acc, metric) => {
      const operation = getOperationTypeFromRuleAggType(metric.aggType);
      let sourceField = metric.field;
      if (metric.aggType === _types.Aggregators.COUNT) {
        sourceField = '___records___';
      }
      let operationField = `${operation}(${sourceField})`;
      if (metric !== null && metric !== void 0 && metric.filter) {
        const aggFilter = JSON.stringify(metric.filter).replace(/"|\\/g, '');
        operationField = `${operation}(${sourceField},kql='${aggFilter}')`;
      }
      return {
        ...acc,
        [metric.name]: operationField
      };
    }, {});
    setAggMap(aggMapFromMetrics);
  }, [metrics]);

  // Parse the equation
  (0, _react.useEffect)(() => {
    try {
      if (!aggMap) return;
      const parser = new _painless_tinymath_parser.PainlessTinyMathParser({
        aggMap,
        equation: equation || Object.keys(aggMap || {}).join(' + ')
      });
      setFormula(parser.parse());
    } catch (e) {
      // The error will appear on Lens chart.
      setAttributes(undefined);
      return;
    }
  }, [aggMap, equation]);
  (0, _react.useEffect)(() => {
    var _metrics$0$field2;
    if (!formulaAsync.value || !dataView || !formula) {
      return;
    }
    const isPercent = Boolean(metrics.length === 1 && ((_metrics$0$field2 = metrics[0].field) === null || _metrics$0$field2 === void 0 ? void 0 : _metrics$0$field2.endsWith('.pct')));
    const baseLayer = {
      type: 'formula',
      value: formula,
      label: 'Custom Threshold',
      groupBy,
      format: {
        id: isPercent ? 'percent' : 'number',
        params: {
          decimals: isPercent ? 0 : 2
        }
      }
    };
    const xYDataLayerOptions = {
      buckets: {
        type: 'date_histogram',
        params: {
          interval: `${timeSize}${timeUnit}`
        }
      },
      seriesType: 'bar'
    };
    if (groupBy && groupBy !== null && groupBy !== void 0 && groupBy.length) {
      xYDataLayerOptions.breakdown = {
        type: 'top_values',
        field: groupBy[0],
        params: {
          size: 3,
          secondaryFields: groupBy.slice(1),
          accuracyMode: false
        }
      };
    }
    const xyDataLayer = new _lensEmbeddableUtils.XYDataLayer({
      data: [baseLayer].map(layer => ({
        type: layer.type,
        value: layer.value,
        label: layer.label,
        format: layer.format
      })),
      options: xYDataLayerOptions
    });
    const layers = [xyDataLayer];
    if (thresholdReferenceLine) {
      layers.push(...thresholdReferenceLine);
    }
    const attributesLens = new _lensEmbeddableUtils.LensAttributesBuilder({
      visualization: new _lensEmbeddableUtils.XYChart({
        visualOptions: {
          valueLabels: 'hide',
          axisTitlesVisibilitySettings: {
            x: true,
            yLeft: false,
            yRight: true
          }
        },
        layers,
        formulaAPI: formulaAsync.value.formula,
        dataView
      })
    }).build();
    const lensBuilderAtt = {
      ...attributesLens,
      type: 'lens'
    };
    setAttributes(lensBuilderAtt);
  }, [comparator, dataView, equation, filterQuery, formula, formulaAsync.value, groupBy, metrics, threshold, thresholdReferenceLine, timeSize, timeUnit]);
  if (!dataView || !attributes || error !== null && error !== void 0 && error.equation || Object.keys((error === null || error === void 0 ? void 0 : error.metrics) || {}).length !== 0 || !timeSize) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        maxHeight: 180,
        minHeight: 180
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "visArea",
      titleSize: "xxs",
      "data-test-subj": "thresholdRuleNoChartData",
      body: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability.customThreshold.rule..charts.noData.title",
        defaultMessage: "No chart data available, check the rule {errorSourceField}",
        values: {
          errorSourceField: Object.keys((error === null || error === void 0 ? void 0 : error.metrics) || {}).length !== 0 ? 'aggregation fields' : error !== null && error !== void 0 && error.equation ? 'equation' : 'conditions'
        }
      })
    }));
  }
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(lens.EmbeddableComponent, {
    onLoad: setChartLoading,
    id: "customThresholdPreviewChart",
    style: {
      height: 180
    },
    timeRange: {
      from: `now-${timeSize * 20}${timeUnit}`,
      to: 'now'
    },
    attributes: attributes,
    disableTriggers: true,
    query: {
      language: 'kuery',
      query: filterQuery || ''
    }
  }));
}