"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GroupBy = GroupBy;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GroupBy({
  options,
  onChange,
  fields,
  errorOptions,
  ...rest
}) {
  const handleChange = (0, _react.useCallback)(selectedOptions => {
    const groupBy = selectedOptions.map(option => option.label);
    onChange(groupBy);
  }, [onChange]);
  const selectedOptions = Array.isArray(options.groupBy) ? options.groupBy.map(field => ({
    label: field,
    color: errorOptions !== null && errorOptions !== void 0 && errorOptions.includes(field) ? 'danger' : undefined
  })) : options.groupBy ? [{
    label: options.groupBy,
    color: errorOptions !== null && errorOptions !== void 0 && errorOptions.includes(options.groupBy) ? 'danger' : undefined
  }] : [];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, (0, _extends2.default)({
    "data-test-subj": "thresholdRuleMetricsExplorer-groupBy",
    placeholder: _i18n.i18n.translate('xpack.observability.threshold.ruleExplorer.groupByLabel', {
      defaultMessage: 'Everything'
    }),
    "aria-label": _i18n.i18n.translate('xpack.observability.threshold.ruleExplorer.groupByAriaLabel', {
      defaultMessage: 'Graph per'
    }),
    fullWidth: true,
    singleSelection: false,
    selectedOptions: selectedOptions,
    options: fields.filter(f => f.aggregatable && f.type === 'string').map(f => ({
      label: f.name
    })),
    onChange: handleChange,
    isClearable: true
  }, rest));
}