"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSloAlertsTableConfiguration = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("../../../../common");
var _render_cell_value = require("./render_cell_value");
var _default_columns = require("./default_columns");
var _use_get_alert_flyout_components = require("../../alerts_flyout/use_get_alert_flyout_components");
var _constants = require("../../../embeddable/slo/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSloAlertsTableConfiguration = (observabilityRuleTypeRegistry, config) => ({
  id: _constants.SLO_ALERTS_TABLE_CONFID,
  cases: {
    featureId: _common.casesFeatureId,
    owner: [_common.observabilityFeatureId]
  },
  columns: _default_columns.columns,
  getRenderCellValue: ({
    setFlyoutAlert
  }) => {
    return (0, _render_cell_value.getRenderCellValue)({
      observabilityRuleTypeRegistry,
      setFlyoutAlert
    });
  },
  sort: [{
    [_ruleDataUtils.TIMESTAMP]: {
      order: 'desc'
    }
  }],
  useInternalFlyout: () => {
    const {
      header,
      body,
      footer
    } = (0, _use_get_alert_flyout_components.useGetAlertFlyoutComponents)(observabilityRuleTypeRegistry);
    return {
      header,
      body,
      footer
    };
  }
});
exports.getSloAlertsTableConfiguration = getSloAlertsTableConfiguration;