"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.columns = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * We need to produce types and code transpilation at different folders during the build of the package.
 * We have types and code at different imports because we don't want to import the whole package in the resulting webpack bundle for the plugin.
 * This way plugins can do targeted imports to reduce the final code bundle
 */

/**
 * columns implements a subset of `EuiDataGrid`'s `EuiDataGridColumn` interface,
 * plus additional TGrid column properties
 */
const columns = [{
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.observability.sloAlertsEmbeddable.alertsTGrid.statusColumnDescription', {
    defaultMessage: 'Status'
  }),
  id: _ruleDataUtils.ALERT_STATUS,
  initialWidth: 110
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.durationColumnDescription', {
    defaultMessage: 'Duration'
  }),
  id: _ruleDataUtils.ALERT_DURATION,
  initialWidth: 116
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.sloColumnDescription', {
    defaultMessage: 'Rule name'
  }),
  id: _ruleDataUtils.ALERT_RULE_NAME,
  initialWidth: 110
}, {
  columnHeaderType: 'not-filtered',
  displayAsText: _i18n.i18n.translate('xpack.observability.alertsTGrid.reasonColumnDescription', {
    defaultMessage: 'Reason'
  }),
  id: _ruleDataUtils.ALERT_REASON,
  linkField: '*'
}];
exports.columns = columns;