"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasLogMonitoringPrivileges = hasLogMonitoringPrivileges;
var _monitoring_config = require("./monitoring_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function hasLogMonitoringPrivileges(esClient) {
  const res = await esClient.security.hasPrivileges({
    body: {
      index: _monitoring_config.indices,
      cluster: [..._monitoring_config.cluster, 'manage_own_api_key']
    }
  });
  return res.has_all_requested;
}