"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemLogs = SystemLogs;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/observability-shared-plugin/public");
var _react = _interopRequireDefault(require("react"));
var _public2 = require("@kbn/kibana-react-plugin/public");
var _app = require("../../application/app");
var _system_logs = require("../../components/app/system_logs");
var _header_action_menu = require("../../components/app/header_action_menu");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SystemLogs({
  children
}) {
  (0, _public.useBreadcrumbs)([{
    text: _i18n.i18n.translate('xpack.observability_onboarding.breadcrumbs.systemLogs', {
      defaultMessage: 'System logs'
    })
  }], _app.breadcrumbsApp);
  const {
    services: {
      config
    }
  } = (0, _public2.useKibana)();
  const isServerless = config.serverless.enabled;
  return /*#__PURE__*/_react.default.createElement(_system_logs.Provider, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    "data-test-subj": "obltOnboardingSystemLogsFilePageHeader"
  }, /*#__PURE__*/_react.default.createElement("h1", null, _i18n.i18n.translate('xpack.observability_onboarding.title.collectSystemLogs', {
    defaultMessage: 'Install shipper to collect system logs'
  })))), isServerless && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: {
      position: 'absolute',
      right: 10
    }
  }, /*#__PURE__*/_react.default.createElement(_header_action_menu.ObservabilityOnboardingHeaderActionMenu, null)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    style: {
      width: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      display: 'flex',
      flexFlow: 'column nowrap'
    }
  }, children))));
}