"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityOnboardingPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _common = require("../common");
var _locator_definition = require("./locators/onboarding_locator/locator_definition");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; } /*
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * or more contributor license agreements. Licensed under the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0; you may not use this file except in compliance with the Elastic License
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      * 2.0.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      */
class ObservabilityOnboardingPlugin {
  constructor(ctx) {
    (0, _defineProperty2.default)(this, "locators", void 0);
    this.ctx = ctx;
  }
  setup(core, plugins) {
    const config = this.ctx.config.get();
    const {
      ui: {
        enabled: isObservabilityOnboardingUiEnabled
      },
      serverless: {
        enabled: isServerlessEnabled
      }
    } = config;
    const pluginSetupDeps = plugins;

    // set xpack.observability_onboarding.ui.enabled: true
    // and go to /app/observabilityOnboarding
    if (isObservabilityOnboardingUiEnabled) {
      core.application.register({
        navLinkStatus: isServerlessEnabled ? _public.AppNavLinkStatus.visible : _public.AppNavLinkStatus.hidden,
        id: _common.PLUGIN_ID,
        title: 'Observability Onboarding',
        order: 8500,
        euiIconType: 'logoObservability',
        category: _public.DEFAULT_APP_CATEGORIES.observability,
        keywords: [],
        async mount(appMountParameters) {
          // Load application bundle and Get start service
          const [{
            renderApp
          }, [coreStart, corePlugins]] = await Promise.all([Promise.resolve().then(() => _interopRequireWildcard(require('./application/app'))), core.getStartServices()]);
          const {
            createCallApi
          } = await Promise.resolve().then(() => _interopRequireWildcard(require('./services/rest/create_call_api')));
          createCallApi(core);
          return renderApp({
            core: coreStart,
            deps: pluginSetupDeps,
            appMountParameters,
            corePlugins: corePlugins,
            config
          });
        }
      });
    }
    this.locators = {
      onboarding: plugins.share.url.locators.create(new _locator_definition.ObservabilityOnboardingLocatorDefinition())
    };
    return {
      locators: this.locators
    };
  }
  start(core, plugins) {
    return {
      locators: this.locators
    };
  }
}
exports.ObservabilityOnboardingPlugin = ObservabilityOnboardingPlugin;