"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useKibanaNavigation = useKibanaNavigation;
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useKibanaNavigation() {
  const {
    application: {
      navigateToUrl,
      navigateToApp
    },
    http: {
      basePath
    }
  } = (0, _public.useKibana)().services;
  const navigateToKibanaUrl = kibanaPath => {
    navigateToUrl(basePath.prepend(kibanaPath), {});
  };
  const navigateToAppUrl = path => {
    navigateToApp('', {
      path,
      openInNewTab: true
    });
  };
  return {
    navigateToKibanaUrl,
    navigateToAppUrl
  };
}