"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackButton = BackButton;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function BackButton({
  onBack
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "observabilityOnboardingBackButtonBackButton",
    iconType: "arrowLeft",
    color: "primary",
    onClick: onBack
  }, _i18n.i18n.translate('xpack.observability_onboarding.steps.back', {
    defaultMessage: 'Back'
  }));
}