"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemIntegrationBanner = SystemIntegrationBanner;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_install_system_integration = require("../../../hooks/use_install_system_integration");
var _use_kibana_navigation = require("../../../hooks/use_kibana_navigation");
var _popover_tooltip = require("../../shared/popover_tooltip");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SystemIntegrationBanner({
  onStatusChange
}) {
  const {
    navigateToAppUrl
  } = (0, _use_kibana_navigation.useKibanaNavigation)();
  const [integrationVersion, setIntegrationVersion] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const onIntegrationCreationSuccess = (0, _react.useCallback)(({
    version
  }) => {
    setIntegrationVersion(version);
    onStatusChange('resolved');
  }, [onStatusChange]);
  const onIntegrationCreationFailure = (0, _react.useCallback)(e => {
    setError(e);
    onStatusChange('rejected');
  }, [onStatusChange]);
  const {
    performRequest,
    requestState
  } = (0, _use_install_system_integration.useInstallSystemIntegration)({
    onIntegrationCreationSuccess,
    onIntegrationCreationFailure
  });
  (0, _react.useEffect)(() => {
    performRequest();
  }, [performRequest]);
  const isInstallingIntegration = requestState.state === 'pending';
  const hasFailedInstallingIntegration = requestState.state === 'rejected';
  const hasInstalledIntegration = requestState.state === 'resolved';
  if (isInstallingIntegration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        gutterSize: "m"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.observability_onboarding.systemIntegration.installing', {
        defaultMessage: 'Installing system integration'
      }))),
      color: "primary",
      "data-test-subj": "obltOnboardingSystemLogsInstallingIntegration"
    });
  }
  if (hasFailedInstallingIntegration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.systemIntegration.status.failed', {
        defaultMessage: 'System integration installation failed'
      }),
      color: "warning",
      iconType: "warning",
      "data-test-subj": "obltOnboardingSystemLogsIntegrationInstallationFailed"
    }, error === null || error === void 0 ? void 0 : error.message));
  }
  if (hasInstalledIntegration) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.systemIntegration.installed",
        defaultMessage: "System integration installed. {systemIntegrationTooltip}",
        values: {
          systemIntegrationTooltip: /*#__PURE__*/_react.default.createElement(_popover_tooltip.PopoverTooltip, {
            dataTestSubj: "obltOnboardingSystemLogsIntegrationInfo",
            ariaLabel: _i18n.i18n.translate('xpack.observability_onboarding.systemIntegration.installed.tooltip.label', {
              defaultMessage: 'Integration details'
            })
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            direction: "column",
            gutterSize: "xs"
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, _i18n.i18n.translate('xpack.observability_onboarding.systemIntegration.installed.tooltip.description', {
            defaultMessage: 'Integrations streamline connecting your data to the Elastic Stack.'
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            style: {
              flexDirection: 'row',
              alignItems: 'center'
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.observability_onboarding.systemIntegration.installed.tooltip.link",
            defaultMessage: "{learnMoreLink} about the data you can collect using the Systems integration.",
            values: {
              learnMoreLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
                "data-test-subj": "observabilityOnboardingSystemIntegrationLearnMore",
                target: "_blank",
                style: {
                  marginRight: '3px'
                },
                onClick: event => {
                  event.preventDefault();
                  navigateToAppUrl(`/integrations/detail/system-${integrationVersion}`);
                }
              }, _i18n.i18n.translate('xpack.observability_onboarding.systemIntegration.installed.tooltip.link.label', {
                defaultMessage: 'Learn more'
              }))
            }
          }))))
        }
      }),
      color: "success",
      iconType: "check",
      "data-test-subj": "obltOnboardingSystemLogsIntegrationInstalled"
    }));
  }
  return null;
}