"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectLogs = SelectLogs;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _step_panel = require("../../shared/step_panel");
var _ = require(".");
var _use_kibana_navigation = require("../../../hooks/use_kibana_navigation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @elastic/eui/href-or-on-click */

function SelectLogs() {
  const {
    navigateToKibanaUrl,
    navigateToAppUrl
  } = (0, _use_kibana_navigation.useKibanaNavigation)();
  const {
    goToStep,
    setState
  } = (0, _.useWizard)();
  function onBack() {
    navigateToKibanaUrl('/app/observabilityOnboarding');
  }
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.chooseType', {
      defaultMessage: 'What logs do you want to collect?'
    }),
    panelFooter: /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
      items: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "observabilityOnboardingSelectLogsBackButton",
        color: "text",
        onClick: onBack
      }, _i18n.i18n.translate('xpack.observability_onboarding.steps.back', {
        defaultMessage: 'Back'
      })), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null)]
    })
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      width: '50%'
    }
  }, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.streamLogFiles', {
      defaultMessage: 'Stream log files'
    }),
    iconType: "desktop",
    onClick: () => {
      setState(state => ({
        ...state,
        logsType: 'log-file'
      }));
      goToStep('configureLogs');
    },
    description: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.streamLogFiles.description', {
      defaultMessage: 'Stream your log file or directory.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(LogsTypeSection, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.networkStreamingLogs', {
      defaultMessage: 'Network streaming logs'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.sysLog', {
      defaultMessage: 'TCP/UDP/Syslog'
    }),
    iconType: "documents",
    onClick: () => {},
    description: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.sysLog.description', {
      defaultMessage: 'Stream logs over TCP or UDP ports or from your syslog server.'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.httpEndpointLogs', {
      defaultMessage: 'HTTP Endpoint'
    }),
    iconType: "documents",
    onClick: () => {},
    description: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.httpEndpointLogs.description', {
      defaultMessage: 'Collect JSON data from listening HTTP port.'
    })
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(LogsTypeSection, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.other', {
      defaultMessage: 'Other'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.uploadLogFiles', {
      defaultMessage: 'Upload log files'
    }),
    iconType: "exportAction",
    onClick: () => {},
    description: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.uploadLogFiles.description', {
      defaultMessage: 'Upload data from a CSV, TSV, JSON or other log file type for analysis.'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(OptionCard, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.useOwnShipper', {
      defaultMessage: 'Get an API key'
    }),
    iconType: "package",
    onClick: () => {},
    description: _i18n.i18n.translate('xpack.observability_onboarding.selectLogs.useOwnShipper.description', {
      defaultMessage: 'Use your own shipper to collect logs data by generating an API key.'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "observabilityOnboardingSelectLogsExploreOtherIntegrationsLink",
    href: "#",
    target: "_blank",
    onClick: event => {
      event.preventDefault();
      navigateToAppUrl('/integrations/browse/observability');
    }
  }, _i18n.i18n.translate('xpack.observability_onboarding.exploreOtherIntegrations', {
    defaultMessage: 'Explore other integrations'
  })))));
}
function LogsTypeSection({
  title,
  children
}) {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), children);
}
function OptionCard({
  title,
  iconType,
  onClick,
  description
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: iconType,
      size: "l"
    }),
    title: title,
    titleSize: "xs",
    paddingSize: "m",
    onClick: onClick,
    hasBorder: true,
    description: description
  });
}