"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstallElasticAgent = InstallElasticAgent;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _react = _interopRequireWildcard(require("react"));
var _locators = require("@kbn/deeplinks-observability/locators");
var _ = require(".");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _get_elastic_agent_setup_command = require("../../shared/get_elastic_agent_setup_command");
var _install_elastic_agent_steps = require("../../shared/install_elastic_agent_steps");
var _step_panel = require("../../shared/step_panel");
var _api_key_banner = require("./api_key_banner");
var _back_button = require("../../shared/back_button");
var _windows_install_step = require("../../shared/windows_install_step");
var _troubleshooting_link = require("../../shared/troubleshooting_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultDatasetName = '';
function InstallElasticAgent() {
  var _ref, _progressData$progres, _progressData$progres2, _progressData$progres3, _progressData$progres4, _progressData$progres5, _progressData$progres6;
  const {
    services: {
      share
    }
  } = (0, _public.useKibana)();
  const singleDatasetLocator = share.url.locators.get(_locators.SINGLE_DATASET_LOCATOR_ID);
  const {
    goBack,
    getState,
    setState
  } = (0, _.useWizard)();
  const wizardState = getState();
  const {
    integrationName: integration,
    datasetName: dataset,
    autoDownloadConfig
  } = wizardState;
  const [elasticAgentPlatform, setElasticAgentPlatform] = (0, _react.useState)('linux-tar');
  const enforcedDatasetName = (_ref = integration === dataset ? dataset : `${integration}.${dataset}`) !== null && _ref !== void 0 ? _ref : defaultDatasetName;
  async function onContinue() {
    await singleDatasetLocator.navigate({
      integration,
      dataset: enforcedDatasetName,
      origin: {
        id: 'application-log-onboarding'
      }
    });
  }
  function onAutoDownloadConfig() {
    setState(state => ({
      ...state,
      autoDownloadConfig: !state.autoDownloadConfig
    }));
  }
  const {
    data: monitoringRole,
    status: monitoringRoleStatus
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (!hasAlreadySavedFlow(getState())) {
      return callApi('GET /internal/observability_onboarding/logs/setup/privileges');
    }
  }, []);
  const {
    data: setup
  } = (0, _use_fetcher.useFetcher)(callApi => {
    return callApi('GET /internal/observability_onboarding/logs/setup/environment');
  }, []);
  const {
    data: installShipperSetup,
    status: installShipperSetupStatus,
    error
  } = (0, _use_fetcher.useFetcher)(callApi => {
    const {
      datasetName,
      serviceName,
      namespace,
      customConfigurations,
      logFilePaths
    } = getState();
    if (!hasAlreadySavedFlow(getState()) && monitoringRole !== null && monitoringRole !== void 0 && monitoringRole.hasPrivileges && datasetName) {
      return callApi('POST /internal/observability_onboarding/logs/flow', {
        params: {
          body: {
            name: datasetName,
            type: 'logFiles',
            state: {
              datasetName,
              serviceName,
              namespace,
              customConfigurations,
              logFilePaths
            }
          }
        }
      });
    }
  }, [monitoringRole === null || monitoringRole === void 0 ? void 0 : monitoringRole.hasPrivileges]);
  const {
    status: saveOnboardingStateDataStatus
  } = (0, _use_fetcher.useFetcher)(callApi => {
    const {
      onboardingId,
      datasetName,
      serviceName,
      namespace,
      customConfigurations,
      logFilePaths
    } = getState();
    if (onboardingId) {
      return callApi('PUT /internal/observability_onboarding/flow/{onboardingId}', {
        params: {
          path: {
            onboardingId
          },
          body: {
            state: {
              datasetName,
              serviceName,
              namespace,
              customConfigurations,
              logFilePaths
            }
          }
        }
      });
    }
  }, []);
  const {
    apiKeyEncoded,
    onboardingId
  } = installShipperSetup !== null && installShipperSetup !== void 0 ? installShipperSetup : getState();
  const {
    data: yamlConfig = '',
    status: yamlConfigStatus
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (apiKeyEncoded && onboardingId) {
      return callApi('GET /internal/observability_onboarding/elastic_agent/config', {
        headers: {
          authorization: `ApiKey ${apiKeyEncoded}`
        },
        params: {
          query: {
            onboardingId
          }
        }
      });
    }
  }, [apiKeyEncoded, onboardingId, saveOnboardingStateDataStatus === _use_fetcher.FETCH_STATUS.SUCCESS]);
  (0, _react.useEffect)(() => {
    setState(state => ({
      ...state,
      onboardingId,
      apiKeyEncoded
    }));
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [onboardingId, apiKeyEncoded]);
  const {
    data: progressData,
    status: progressStatus,
    refetch: refetchProgress
  } = (0, _use_fetcher.useFetcher)(callApi => {
    if (onboardingId) {
      return callApi('GET /internal/observability_onboarding/flow/{onboardingId}/progress', {
        params: {
          path: {
            onboardingId
          }
        }
      });
    }
  }, [onboardingId]);
  const progressSucceded = progressStatus === _use_fetcher.FETCH_STATUS.SUCCESS;
  (0, _react.useEffect)(() => {
    if (progressSucceded) {
      setTimeout(() => {
        refetchProgress();
      }, 2000);
    }
  }, [progressSucceded, refetchProgress]);
  const getCheckLogsStep = (0, _react.useCallback)(() => {
    const progress = progressData === null || progressData === void 0 ? void 0 : progressData.progress;
    if (progress) {
      var _progress$logsIngest;
      const stepStatus = progress === null || progress === void 0 ? void 0 : (_progress$logsIngest = progress['logs-ingest']) === null || _progress$logsIngest === void 0 ? void 0 : _progress$logsIngest.status;
      const title = stepStatus === 'loading' ? CHECK_LOGS_LABELS.loading : stepStatus === 'complete' ? CHECK_LOGS_LABELS.completed : CHECK_LOGS_LABELS.incomplete;
      return {
        title,
        status: stepStatus,
        'data-test-subj': 'obltOnboardingCheckLogsStep'
      };
    }
    return {
      title: CHECK_LOGS_LABELS.incomplete,
      status: 'incomplete'
    };
  }, [progressData === null || progressData === void 0 ? void 0 : progressData.progress]);
  const isInstallStarted = (progressData === null || progressData === void 0 ? void 0 : progressData.progress['ea-download']) !== undefined;
  const isInstallCompleted = (progressData === null || progressData === void 0 ? void 0 : (_progressData$progres = progressData.progress) === null || _progressData$progres === void 0 ? void 0 : (_progressData$progres2 = _progressData$progres['ea-status']) === null || _progressData$progres2 === void 0 ? void 0 : _progressData$progres2.status) === 'complete';
  const autoDownloadConfigStatus = (_progressData$progres3 = progressData === null || progressData === void 0 ? void 0 : (_progressData$progres4 = progressData.progress) === null || _progressData$progres4 === void 0 ? void 0 : (_progressData$progres5 = _progressData$progres4['ea-config']) === null || _progressData$progres5 === void 0 ? void 0 : _progressData$progres5.status) !== null && _progressData$progres3 !== void 0 ? _progressData$progres3 : 'incomplete';
  return /*#__PURE__*/_react.default.createElement(_step_panel.StepPanel, {
    panelFooter: /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelFooter, {
      items: [/*#__PURE__*/_react.default.createElement(_back_button.BackButton, {
        onBack: goBack
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "obltOnboardingExploreLogs",
        color: "success",
        fill: true,
        iconType: "magnifyWithPlus",
        onClick: onContinue
      }, _i18n.i18n.translate('xpack.observability_onboarding.steps.exploreLogs', {
        defaultMessage: 'Explore logs'
      }))]
    })
  }, /*#__PURE__*/_react.default.createElement(_step_panel.StepPanelContent, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.description', {
    defaultMessage: 'To collect the data from your system and stream it to Elastic, you first need to install a shipping tool on the machine generating the logs. In this case, the shipping tool is an agent developed by Elastic.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), integration && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.integrationSuccessCallout.title', {
      defaultMessage: '{integrationName} integration installed.',
      values: {
        integrationName: integration
      }
    }),
    color: "success",
    iconType: "check",
    "data-test-subj": "obltOnboardingCustomIntegrationInstalled"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), apiKeyEncoded && onboardingId ? /*#__PURE__*/_react.default.createElement(_api_key_banner.ApiKeyBanner, {
    payload: {
      apiKeyEncoded,
      onboardingId
    },
    hasPrivileges: true,
    status: _use_fetcher.FETCH_STATUS.SUCCESS
  }) : monitoringRoleStatus !== _use_fetcher.FETCH_STATUS.NOT_INITIATED && monitoringRoleStatus !== _use_fetcher.FETCH_STATUS.LOADING && /*#__PURE__*/_react.default.createElement(_api_key_banner.ApiKeyBanner, {
    payload: installShipperSetup,
    hasPrivileges: monitoringRole === null || monitoringRole === void 0 ? void 0 : monitoringRole.hasPrivileges,
    status: installShipperSetupStatus,
    error: error
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_install_elastic_agent_steps.InstallElasticAgentSteps, {
    installAgentPlatformOptions: [{
      label: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform.linux', {
        defaultMessage: 'Linux'
      }),
      id: 'linux-tar'
    }, {
      label: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform.macOS', {
        defaultMessage: 'MacOS'
      }),
      id: 'macos'
    }, {
      label: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.installStep.choosePlatform.windows', {
        defaultMessage: 'Windows'
      }),
      id: 'windows',
      disableSteps: true,
      children: /*#__PURE__*/_react.default.createElement(_windows_install_step.WindowsInstallStep, {
        docsLink: "https://www.elastic.co/guide/en/observability/current/logs-stream.html"
      })
    }],
    onSelectPlatform: id => setElasticAgentPlatform(id),
    selectedPlatform: elasticAgentPlatform,
    installAgentCommand: (0, _get_elastic_agent_setup_command.getElasticAgentSetupCommand)({
      elasticAgentPlatform,
      apiKeyEncoded,
      apiEndpoint: setup === null || setup === void 0 ? void 0 : setup.apiEndpoint,
      scriptDownloadUrl: setup === null || setup === void 0 ? void 0 : setup.scriptDownloadUrl,
      elasticAgentVersion: setup === null || setup === void 0 ? void 0 : setup.elasticAgentVersion,
      autoDownloadConfig,
      onboardingId
    }),
    autoDownloadConfig: autoDownloadConfig,
    onToggleAutoDownloadConfig: onAutoDownloadConfig,
    installAgentStatus: installShipperSetupStatus === _use_fetcher.FETCH_STATUS.LOADING ? 'loading' : isInstallCompleted ? 'complete' : 'current',
    showInstallProgressSteps: isInstallStarted,
    installProgressSteps: (_progressData$progres6 = progressData === null || progressData === void 0 ? void 0 : progressData.progress) !== null && _progressData$progres6 !== void 0 ? _progressData$progres6 : {},
    configureAgentStatus: yamlConfigStatus === _use_fetcher.FETCH_STATUS.LOADING ? 'loading' : autoDownloadConfigStatus,
    configureAgentYaml: yamlConfig,
    appendedSteps: [getCheckLogsStep()]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_troubleshooting_link.TroubleshootingLink, null));
}
function hasAlreadySavedFlow({
  apiKeyEncoded,
  onboardingId
}) {
  return Boolean(apiKeyEncoded && onboardingId);
}
const CHECK_LOGS_LABELS = {
  incomplete: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.logsIngest.incompleteTitle', {
    defaultMessage: 'Ship logs to Elastic Observability'
  }),
  loading: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.logsIngest.loadingTitle', {
    defaultMessage: 'Waiting for logs to be shipped...'
  }),
  completed: _i18n.i18n.translate('xpack.observability_onboarding.installElasticAgent.progress.logsIngest.completedTitle', {
    defaultMessage: 'Logs are being shipped!'
  })
};