"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getSystemLogsDataStreams = exports.generateSystemLogsYml = void 0;
var _jsYaml = require("js-yaml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateSystemLogsYml = ({
  namespace = 'default',
  apiKey,
  esHost,
  uuid
}) => {
  return (0, _jsYaml.dump)({
    outputs: {
      default: {
        type: 'elasticsearch',
        hosts: esHost,
        api_key: apiKey
      }
    },
    inputs: [{
      id: `system-logs-${uuid}`,
      type: 'logfile',
      data_stream: {
        namespace
      },
      streams: getSystemLogsDataStreams(uuid)
    }]
  });
};

/*
 * Utils
 */
exports.generateSystemLogsYml = generateSystemLogsYml;
const getSystemLogsDataStreams = (uuid = '') => [{
  id: `logfile-system.auth-${uuid}`,
  data_stream: {
    dataset: 'system.auth',
    type: 'logs'
  },
  paths: ['/var/log/auth.log*', '/var/log/secure*'],
  exclude_files: ['.gz$'],
  multiline: {
    pattern: '^s',
    match: 'after'
  },
  tags: ['system-auth'],
  processors: [{
    add_locale: null
  }]
}, {
  id: `logfile-system.syslog-${uuid}`,
  data_stream: {
    dataset: 'system.syslog',
    type: 'logs'
  },
  paths: ['/var/log/messages*', '/var/log/syslog*', '/var/log/system*'],
  exclude_files: ['.gz$'],
  multiline: {
    pattern: '^s',
    match: 'after'
  },
  processors: [{
    add_locale: null
  }]
}];
exports.getSystemLogsDataStreams = getSystemLogsDataStreams;