"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservablityLogExplorerMainRoute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _rxjs = require("rxjs");
var _log_explorer_top_nav_menu = require("../../components/log_explorer_top_nav_menu");
var _page_template = require("../../components/page_template");
var _breadcrumbs = require("../../utils/breadcrumbs");
var _use_kibana = require("../../utils/use_kibana");
var _lazy_component = require("../../state_machines/origin_interpreter/src/lazy_component");
var _log_explorer_customizations = require("../../log_explorer_customizations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ObservablityLogExplorerMainRoute = ({
  appParams,
  core
}) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    logExplorer,
    observabilityShared,
    serverless
  } = services;
  (0, _breadcrumbs.useBreadcrumbs)(_breadcrumbs.noBreadcrumbs, core.chrome, serverless);
  const {
    history,
    setHeaderActionMenu,
    theme$
  } = appParams;
  const [state$] = (0, _react.useState)(() => new _rxjs.BehaviorSubject({}));
  const customizations = (0, _react.useMemo)(() => (0, _log_explorer_customizations.createLogExplorerCustomizations)(), []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_log_explorer_top_nav_menu.LogExplorerTopNavMenu, {
    setHeaderActionMenu: setHeaderActionMenu,
    services: services,
    state$: state$,
    theme$: theme$
  }), /*#__PURE__*/_react.default.createElement(_lazy_component.LazyOriginInterpreter, {
    history: history,
    toasts: core.notifications.toasts
  }), /*#__PURE__*/_react.default.createElement(_page_template.ObservabilityLogExplorerPageTemplate, {
    observabilityShared: observabilityShared
  }, /*#__PURE__*/_react.default.createElement(logExplorer.LogExplorer, {
    customizations: customizations,
    scopedHistory: history,
    state$: state$
  })));
};
exports.ObservablityLogExplorerMainRoute = ObservablityLogExplorerMainRoute;