"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.functionRoutes = void 0;
var _boom = require("@hapi/boom");
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _types = require("../../../common/types");
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFunctionsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/functions',
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request
    } = resources;
    const controller = new AbortController();
    request.events.aborted$.subscribe(() => {
      controller.abort();
    });
    const client = await service.getClient({
      request
    });
    const functionClient = await service.getFunctionClient({
      signal: controller.signal,
      resources,
      client
    });
    return {
      functionDefinitions: functionClient.getFunctions().map(fn => fn.definition),
      contextDefinitions: functionClient.getContexts()
    };
  }
});
const functionRecallRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/functions/recall',
  params: t.type({
    body: t.intersection([t.type({
      queries: t.array(_ioTsUtils.nonEmptyStringRt)
    }), t.partial({
      contexts: t.array(t.string)
    })])
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const {
      body: {
        queries,
        contexts
      }
    } = resources.params;
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.recall({
      queries,
      contexts
    });
  }
});
const functionSummariseRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/functions/summarize',
  params: t.type({
    body: t.type({
      id: t.string,
      text: _ioTsUtils.nonEmptyStringRt,
      confidence: t.union([t.literal('low'), t.literal('medium'), t.literal('high')]),
      is_correction: _ioTsUtils.toBooleanRt,
      public: _ioTsUtils.toBooleanRt,
      labels: t.record(t.string, t.string)
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const {
      confidence,
      id,
      is_correction: isCorrection,
      text,
      public: isPublic,
      labels
    } = resources.params.body;
    return client.createKnowledgeBaseEntry({
      entry: {
        confidence,
        id,
        doc_id: id,
        is_correction: isCorrection,
        text,
        public: isPublic,
        labels,
        role: _types.KnowledgeBaseEntryRole.AssistantSummarization
      }
    });
  }
});
const functionRoutes = {
  ...getFunctionsRoute,
  ...functionRecallRoute,
  ...functionSummariseRoute
};
exports.functionRoutes = functionRoutes;