"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.conversationRoutes = void 0;
var _boom = require("@hapi/boom");
var t = _interopRequireWildcard(require("io-ts"));
var _lodash = require("lodash");
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _runtime_types = require("../runtime_types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.get(params.path.conversationId);
  }
});
const findConversationsRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/conversations',
  params: t.partial({
    body: t.partial({
      query: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    var _params$body;
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.find({
      query: params === null || params === void 0 ? void 0 : (_params$body = params.body) === null || _params$body === void 0 ? void 0 : _params$body.query
    });
  }
});
const createConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/conversation',
  params: t.type({
    body: t.type({
      conversation: _runtime_types.conversationCreateRt
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.create(params.body.conversation);
  }
});
const updateConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'PUT /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    }),
    body: t.type({
      conversation: _runtime_types.conversationUpdateRt
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.update((0, _lodash.merge)({}, params.body.conversation, {
      conversation: {
        id: params.path.conversationId
      }
    }));
  }
});
const updateConversationTitle = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'PUT /internal/observability_ai_assistant/conversation/{conversationId}/title',
  params: t.type({
    path: t.type({
      conversationId: t.string
    }),
    body: t.type({
      title: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    const conversation = await client.setTitle({
      conversationId: params.path.conversationId,
      title: params.body.title
    });
    return Promise.resolve(conversation);
  }
});
const deleteConversationRoute = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'DELETE /internal/observability_ai_assistant/conversation/{conversationId}',
  params: t.type({
    path: t.type({
      conversationId: t.string
    })
  }),
  options: {
    tags: ['access:ai_assistant']
  },
  handler: async resources => {
    const {
      service,
      request,
      params
    } = resources;
    const client = await service.getClient({
      request
    });
    if (!client) {
      throw (0, _boom.notImplemented)();
    }
    return client.delete(params.path.conversationId);
  }
});
const conversationRoutes = {
  ...getConversationRoute,
  ...findConversationsRoute,
  ...createConversationRoute,
  ...updateConversationRoute,
  ...updateConversationTitle,
  ...deleteConversationRoute
};
exports.conversationRoutes = conversationRoutes;