"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createInitializedObject = createInitializedObject;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createInitializedObject(parameters) {
  const emptyObject = {};
  function traverseProperties({
    properties,
    required
  }) {
    for (const propName in properties) {
      if (properties.hasOwnProperty(propName)) {
        const prop = properties[propName];
        if (prop.type === 'object') {
          emptyObject[propName] = createInitializedObject(prop);
        } else if (required !== null && required !== void 0 && required.includes(propName)) {
          if (prop.type === 'array') {
            emptyObject[propName] = [];
          }
          if (prop.type === 'number') {
            emptyObject[propName] = 1;
          }
          if (prop.type === 'string') {
            emptyObject[propName] = '';
          }
        }
      }
    }
  }
  traverseProperties(parameters);
  return emptyObject;
}