"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAssistantSetupMessage = getAssistantSetupMessage;
var _lodash = require("lodash");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAssistantSetupMessage({
  contexts
}) {
  const coreContext = contexts.find(context => context.name === 'core');
  const otherContexts = (0, _lodash.without)(contexts.concat(), coreContext);
  return {
    '@timestamp': new Date().toISOString(),
    message: {
      role: _common.MessageRole.System,
      content: [coreContext, ...otherContexts].map(context => context.description).join('\n')
    }
  };
}