"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useUnmountAndRemountWhenPropChanges = useUnmountAndRemountWhenPropChanges;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useUnmountAndRemountWhenPropChanges(currentProp) {
  const prevPropRef = (0, _react.useRef)(currentProp);
  const [shouldRender, setShouldRender] = (0, _react.useState)(true);
  (0, _react.useEffect)(() => {
    if (prevPropRef.current !== currentProp) {
      setShouldRender(false);
    }
  }, [prevPropRef, currentProp]);
  (0, _react.useEffect)(() => {
    if (!shouldRender) {
      setShouldRender(true);
    }
  }, [shouldRender]);
  (0, _react.useEffect)(() => {
    prevPropRef.current = currentProp;
  }, [currentProp]);
  return shouldRender;
}