"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageText = MessageText;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireWildcard(require("react"));
var _esql_code_block = require("./esql_code_block");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANIMATION_TIME = 1;
const cursorCss = (0, _css.css)`
  @keyframes blink {
    0% {
      opacity: 0;
    }
    50% {
      opacity: 1;
    }
    100% {
      opacity: 0;
    }
  }

  animation: blink ${ANIMATION_TIME}s infinite;
  width: 10px;
  height: 16px;
  vertical-align: middle;
  display: inline-block;
  background: rgba(0, 0, 0, 0.25);
`;
const Cursor = () => /*#__PURE__*/_react.default.createElement("span", {
  key: "cursor",
  className: (0, _classnames.default)(cursorCss, 'cursor')
});

// a weird combination of different whitespace chars to make sure it stays
// invisible even when we cannot properly parse the text while still being
// unique
const CURSOR = ` ᠎  `;
const loadingCursorPlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type !== 'text' && node.type !== 'inlineCode' && node.type !== 'code') {
      return;
    }
    const textNode = node;
    const indexOfCursor = textNode.value.indexOf(CURSOR);
    if (indexOfCursor === -1) {
      return;
    }
    textNode.value = textNode.value.replace(CURSOR, '');
    const indexOfNode = parent.children.indexOf(textNode);
    parent.children.splice(indexOfNode + 1, 0, {
      type: 'cursor',
      value: CURSOR
    });
  };
  return tree => {
    visitor(tree);
  };
};
const esqlLanguagePlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type === 'code' && node.lang === 'esql') {
      node.type = 'esql';
    }
  };
  return tree => {
    visitor(tree);
  };
};
function MessageText({
  loading,
  content,
  onActionClick
}) {
  const containerClassName = (0, _css.css)`
    overflow-wrap: anywhere;
  `;
  const onActionClickRef = (0, _react.useRef)(onActionClick);
  onActionClickRef.current = onActionClick;
  const {
    parsingPluginList,
    processingPluginList
  } = (0, _react.useMemo)(() => {
    const parsingPlugins = (0, _eui.getDefaultEuiMarkdownParsingPlugins)();
    const processingPlugins = (0, _eui.getDefaultEuiMarkdownProcessingPlugins)();
    const {
      components
    } = processingPlugins[1][1];
    processingPlugins[1][1].components = {
      ...components,
      cursor: Cursor,
      esql: props => {
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_esql_code_block.EsqlCodeBlock, {
          value: props.value,
          actionsDisabled: loading,
          onActionClick: onActionClickRef.current
        }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        }));
      },
      table: props => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        className: "euiBasicTable"
      }, ' ', /*#__PURE__*/_react.default.createElement("table", (0, _extends2.default)({
        className: "euiTable"
      }, props))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      })),
      th: props => {
        const {
          children,
          ...rest
        } = props;
        return /*#__PURE__*/_react.default.createElement("th", (0, _extends2.default)({
          className: "euiTableHeaderCell"
        }, rest), /*#__PURE__*/_react.default.createElement("span", {
          className: "euiTableCellContent"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "euiTableCellContent__text",
          title: children
        }, children)));
      },
      tr: props => /*#__PURE__*/_react.default.createElement("tr", (0, _extends2.default)({
        className: "euiTableRow"
      }, props)),
      td: props => {
        const {
          children,
          ...rest
        } = props;
        return /*#__PURE__*/_react.default.createElement("td", (0, _extends2.default)({
          className: "euiTableRowCell"
        }, rest), /*#__PURE__*/_react.default.createElement("div", {
          className: "euiTableCellContent euiTableCellContent--truncateText"
        }, /*#__PURE__*/_react.default.createElement("span", {
          className: "euiTableCellContent__text",
          title: children
        }, children)));
      }
    };
    return {
      parsingPluginList: [loadingCursorPlugin, esqlLanguagePlugin, ...parsingPlugins],
      processingPluginList: processingPlugins
    };
  }, [loading]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    className: containerClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
    textSize: "s",
    parsingPluginList: parsingPluginList,
    processingPluginList: processingPluginList
  }, `${content}${loading ? CURSOR : ''}`));
}