"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Insight = Insight;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _types = require("../../../common/types");
var _analytics = require("../../analytics");
var _observability_ai_assistant_chat_service_provider = require("../../context/observability_ai_assistant_chat_service_provider");
var _use_abortable_async = require("../../hooks/use_abortable_async");
var _use_chat = require("../../hooks/use_chat");
var _use_genai_connectors = require("../../hooks/use_genai_connectors");
var _use_kibana = require("../../hooks/use_kibana");
var _use_observability_ai_assistant = require("../../hooks/use_observability_ai_assistant");
var _use_observability_ai_assistant_chat_service = require("../../hooks/use_observability_ai_assistant_chat_service");
var _get_connectors_management_href = require("../../utils/get_connectors_management_href");
var _regenerate_response_button = require("../buttons/regenerate_response_button");
var _start_chat_button = require("../buttons/start_chat_button");
var _stop_generating_button = require("../buttons/stop_generating_button");
var _chat_flyout = require("../chat/chat_flyout");
var _connector_selector_base = require("../connector_selector/connector_selector_base");
var _feedback_buttons = require("../feedback_buttons");
var _message_panel = require("../message_panel/message_panel");
var _message_text = require("../message_panel/message_text");
var _missing_credentials_callout = require("../missing_credentials_callout");
var _insight_base = require("./insight_base");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function ChatContent({
  title: defaultTitle,
  initialMessages,
  connectorId
}) {
  var _lastAssistantRespons;
  const chatService = (0, _use_observability_ai_assistant_chat_service.useObservabilityAIAssistantChatService)();
  const initialMessagesRef = (0, _react.useRef)(initialMessages);
  const {
    messages,
    next,
    state,
    stop
  } = (0, _use_chat.useChat)({
    chatService,
    connectorId,
    initialMessages,
    persist: false
  });
  const lastAssistantResponse = (0, _lodash.last)(messages.filter(message => message.message.role === _types.MessageRole.Assistant));
  (0, _react.useEffect)(() => {
    next(initialMessagesRef.current);
  }, [next]);
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_message_panel.MessagePanel, {
    body: /*#__PURE__*/_react.default.createElement(_message_text.MessageText, {
      content: (_lastAssistantRespons = lastAssistantResponse === null || lastAssistantResponse === void 0 ? void 0 : lastAssistantResponse.message.content) !== null && _lastAssistantRespons !== void 0 ? _lastAssistantRespons : '',
      loading: state === _use_chat.ChatState.Loading,
      onActionClick: async () => {}
    }),
    error: state === _use_chat.ChatState.Error,
    controls: state === _use_chat.ChatState.Loading ? /*#__PURE__*/_react.default.createElement(_stop_generating_button.StopGeneratingButton, {
      onClick: () => {
        stop();
      }
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row"
    }, /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
      onClickFeedback: feedback => {
        if (lastAssistantResponse) {
          (0, _analytics.sendEvent)(chatService.analytics, {
            type: _analytics.TELEMETRY.observability_ai_assistant_insight_feedback,
            payload: {
              feedback,
              message: lastAssistantResponse
            }
          });
        }
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_regenerate_response_button.RegenerateResponseButton, {
      onClick: () => {
        next(initialMessages);
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_start_chat_button.StartChatButton, {
      onClick: () => {
        setIsOpen(() => true);
      }
    })))
  }), /*#__PURE__*/_react.default.createElement(_chat_flyout.ChatFlyout, {
    isOpen: isOpen,
    onClose: () => {
      setIsOpen(false);
    },
    initialMessages: messages,
    initialTitle: defaultTitle,
    startedFrom: "contextualInsight"
  }));
}
function Insight({
  messages,
  title,
  dataTestSubj
}) {
  var _connectors$connector;
  const [hasOpened, setHasOpened] = (0, _react.useState)(false);
  const connectors = (0, _use_genai_connectors.useGenAIConnectors)();
  const service = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  const chatService = (0, _use_abortable_async.useAbortableAsync)(({
    signal
  }) => {
    return service.start({
      signal
    });
  }, [service]);
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  let children = null;
  if (hasOpened && connectors.selectedConnector) {
    children = /*#__PURE__*/_react.default.createElement(ChatContent, {
      title: title,
      initialMessages: messages,
      connectorId: connectors.selectedConnector
    });
  } else if (!connectors.loading && !((_connectors$connector = connectors.connectors) !== null && _connectors$connector !== void 0 && _connectors$connector.length)) {
    children = /*#__PURE__*/_react.default.createElement(_missing_credentials_callout.MissingCredentialsCallout, {
      connectorsManagementHref: (0, _get_connectors_management_href.getConnectorsManagementHref)(http)
    });
  }
  return /*#__PURE__*/_react.default.createElement(_insight_base.InsightBase, {
    title: title,
    onToggle: isOpen => {
      setHasOpened(prevHasOpened => prevHasOpened || isOpen);
    },
    controls: /*#__PURE__*/_react.default.createElement(_connector_selector_base.ConnectorSelectorBase, connectors),
    loading: connectors.loading || chatService.loading,
    dataTestSubj: dataTestSubj
  }, chatService.value ? /*#__PURE__*/_react.default.createElement(_observability_ai_assistant_chat_service_provider.ObservabilityAIAssistantChatServiceProvider, {
    value: chatService.value
  }, children) : null);
}