"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatItem = ChatItem;
var _react = _interopRequireWildcard(require("react"));
var _css = require("@emotion/css");
var _eui = require("@elastic/eui");
var _chat_item_actions = require("./chat_item_actions");
var _chat_item_avatar = require("./chat_item_avatar");
var _chat_item_content_inline_prompt_editor = require("./chat_item_content_inline_prompt_editor");
var _chat_item_controls = require("./chat_item_controls");
var _get_role_translation = require("../../utils/get_role_translation");
var _failed_to_load_response = require("../message_panel/failed_to_load_response");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const moreCompactHeaderClassName = (0, _css.css)`
  .euiCommentEvent__header > .euiPanel {
    padding-top: 4px;
    padding-bottom: 4px;
  }
`;
const normalMessageClassName = (0, _css.css)`
  ${moreCompactHeaderClassName}

  .euiCommentEvent__body {
    padding: 0;
  }

  /* targets .*euiTimelineItemEvent-top, makes sure text properly wraps and doesn't overflow */
  > :last-child {
    overflow-x: hidden;
  }
`;
const noPanelMessageClassName = (0, _css.css)`
  .euiCommentEvent {
    border: none;
  }

  .euiCommentEvent__header {
    background: transparent;
    border-block-end: none;

    > .euiPanel {
      background: none;
    }
  }

  .euiCommentEvent__body {
    display: none;
  }
`;
function ChatItem({
  actions: {
    canCopy,
    canEdit,
    canGiveFeedback,
    canRegenerate
  },
  content,
  function_call: functionCall,
  role,
  currentUser,
  display: {
    collapsed
  },
  element,
  error,
  loading,
  title,
  onActionClick,
  onEditSubmit,
  onFeedbackClick,
  onRegenerateClick,
  onSendTelemetry,
  onStopGeneratingClick
}) {
  const accordionId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'chat'
  });
  const [editing, setEditing] = (0, _react.useState)(false);
  const [expanded, setExpanded] = (0, _react.useState)(Boolean(element));
  const actions = [canCopy, collapsed, canCopy].filter(Boolean);
  const noBodyMessageClassName = (0, _css.css)`
    ${moreCompactHeaderClassName}

    .euiCommentEvent__body {
      padding: 0;
      height: ${expanded ? 'fit-content' : '0px'};
      overflow: hidden;
      border: none;
    }
  `;
  const handleToggleExpand = () => {
    setExpanded(!expanded);
    if (editing) {
      setEditing(false);
    }
  };
  const handleToggleEdit = () => {
    if (collapsed && !expanded) {
      setExpanded(true);
    }
    setEditing(!editing);
  };
  const handleInlineEditSubmit = newMessage => {
    handleToggleEdit();
    return onEditSubmit(newMessage);
  };
  const handleCopyToClipboard = () => {
    navigator.clipboard.writeText(content || '');
  };
  let contentElement = content || loading || error ? /*#__PURE__*/_react.default.createElement(_chat_item_content_inline_prompt_editor.ChatItemContentInlinePromptEditor, {
    editing: editing,
    loading: loading,
    functionCall: functionCall,
    content: content,
    role: role,
    onSubmit: handleInlineEditSubmit,
    onActionClick: onActionClick,
    onSendTelemetry: onSendTelemetry
  }) : null;
  if (collapsed) {
    contentElement = /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
      id: accordionId,
      arrowDisplay: "none",
      forceState: expanded ? 'open' : 'closed',
      onToggle: handleToggleExpand
    }, contentElement);
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiComment, {
    timelineAvatar: /*#__PURE__*/_react.default.createElement(_chat_item_avatar.ChatItemAvatar, {
      loading: loading,
      currentUser: currentUser,
      role: role
    }),
    username: (0, _get_role_translation.getRoleTranslation)(role),
    event: title,
    actions: /*#__PURE__*/_react.default.createElement(_chat_item_actions.ChatItemActions, {
      canCopy: canCopy,
      canEdit: canEdit,
      collapsed: collapsed,
      editing: editing,
      expanded: expanded,
      onCopyToClipboard: handleCopyToClipboard,
      onToggleEdit: handleToggleEdit,
      onToggleExpand: handleToggleExpand
    }),
    className: actions.length === 0 && !content ? noPanelMessageClassName : collapsed ? noBodyMessageClassName : normalMessageClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    paddingSize: "s"
  }, element ? /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, element) : null, contentElement, error ? /*#__PURE__*/_react.default.createElement(_failed_to_load_response.FailedToLoadResponse, null) : null), /*#__PURE__*/_react.default.createElement(_chat_item_controls.ChatItemControls, {
    canGiveFeedback: canGiveFeedback,
    canRegenerate: canRegenerate,
    error: error,
    loading: loading,
    onFeedbackClick: onFeedbackClick,
    onRegenerateClick: onRegenerateClick,
    onStopGeneratingClick: onStopGeneratingClick
  }));
}