"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ChatHeader = ChatHeader;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _css = require("@emotion/css");
var _assistant_avatar = require("../assistant_avatar");
var _chat_actions_menu = require("./chat_actions_menu");
var _i18n2 = require("../../i18n");
var _use_unmount_and_remount_when_prop_changes = require("../../hooks/use_unmount_and_remount_when_prop_changes");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// needed to prevent InlineTextEdit component from expanding container
const minWidthClassName = (0, _css.css)`
  min-width: 0;
`;
const chatHeaderClassName = (0, _css.css)`
  padding-top: 12px;
  padding-bottom: 12px;
`;
function ChatHeader({
  title,
  loading,
  licenseInvalid,
  connectors,
  connectorsManagementHref,
  conversationId,
  knowledgeBase,
  startedFrom,
  onSaveTitle,
  onCopyConversation
}) {
  const hasTitle = !!title;
  const displayedTitle = !connectors.selectedConnector ? _i18n2.ASSISTANT_SETUP_TITLE : licenseInvalid ? _i18n2.UPGRADE_LICENSE_TITLE : title || _i18n2.EMPTY_CONVERSATION_TITLE;
  const theme = (0, _eui.useEuiTheme)();

  // Component only works uncontrolled at the moment, so need to unmount and remount on prop change.
  // https://github.com/elastic/eui/issues/7084
  const shouldRender = (0, _use_unmount_and_remount_when_prop_changes.useUnmountAndRemountWhenPropChanges)(displayedTitle);
  const inputRef = (0, _react.useRef)(null);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    hasBorder: false,
    hasShadow: false,
    paddingSize: "m",
    className: chatHeaderClassName
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false,
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }) : /*#__PURE__*/_react.default.createElement(_assistant_avatar.AssistantAvatar, {
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true,
    className: minWidthClassName
  }, shouldRender ? /*#__PURE__*/_react.default.createElement(_eui.EuiInlineEditTitle, {
    heading: "h2",
    size: "s",
    defaultValue: displayedTitle,
    className: (0, _css.css)`
                color: ${hasTitle ? theme.euiTheme.colors.text : theme.euiTheme.colors.subduedText};
              `,
    inputAriaLabel: _i18n.i18n.translate('xpack.observabilityAiAssistant.chatHeader.editConversationInput', {
      defaultMessage: 'Edit conversation'
    }),
    editModeProps: {
      inputProps: {
        inputRef
      }
    },
    isReadOnly: !conversationId || !connectors.selectedConnector || licenseInvalid || !Boolean(onSaveTitle),
    onSave: onSaveTitle
  }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_chat_actions_menu.ChatActionsMenu, {
    connectors: connectors,
    disabled: licenseInvalid,
    conversationId: conversationId,
    onCopyConversationClick: onCopyConversation
  }))));
}