"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCallObservabilityAIAssistantAPI = createCallObservabilityAIAssistantAPI;
var _serverRouteRepository = require("@kbn/server-route-repository");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createCallObservabilityAIAssistantAPI(core) {
  return (endpoint, options) => {
    const {
      params
    } = options;
    const {
      method,
      pathname,
      version
    } = (0, _serverRouteRepository.formatRequest)(endpoint, params === null || params === void 0 ? void 0 : params.path);
    return core.http[method](pathname, {
      ...options,
      body: params && params.body ? JSON.stringify(params.body) : undefined,
      query: params === null || params === void 0 ? void 0 : params.query,
      version
    });
  };
}