"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.lensFunctionDefinition = exports.SeriesType = void 0;
var _common = require("@kbn/field-formats-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let SeriesType;
exports.SeriesType = SeriesType;
(function (SeriesType) {
  SeriesType["Bar"] = "bar";
  SeriesType["Line"] = "line";
  SeriesType["Area"] = "area";
  SeriesType["BarStacked"] = "bar_stacked";
  SeriesType["AreaStacked"] = "area_stacked";
  SeriesType["BarHorizontal"] = "bar_horizontal";
  SeriesType["BarPercentageStacked"] = "bar_percentage_stacked";
  SeriesType["AreaPercentageStacked"] = "area_percentage_stacked";
  SeriesType["BarHorizontalPercentageStacked"] = "bar_horizontal_percentage_stacked";
})(SeriesType || (exports.SeriesType = SeriesType = {}));
const lensFunctionDefinition = {
  name: 'lens',
  contexts: ['core'],
  description: "Use this function to create custom visualizations, using Lens, that can be saved to dashboards. This function does not return data to the assistant, it only shows it to the user. When using this function, make sure to use the recall function to get more information about how to use it, with how you want to use it. Make sure the query also contains information about the user's request. The visualisation is displayed to the user above your reply, DO NOT try to generate or display an image yourself.",
  descriptionForUser: 'Use this function to create custom visualizations, using Lens, that can be saved to dashboards.',
  parameters: {
    type: 'object',
    additionalProperties: false,
    properties: {
      layers: {
        type: 'array',
        items: {
          type: 'object',
          additionalProperties: false,
          properties: {
            label: {
              type: 'string'
            },
            formula: {
              type: 'string',
              description: 'The formula for calculating the value, e.g. sum(my_field_name). Query the knowledge base to get more information about the syntax and available formulas.'
            },
            filter: {
              type: 'string',
              description: 'A KQL query that will be used as a filter for the series'
            },
            format: {
              type: 'object',
              additionalProperties: false,
              properties: {
                id: {
                  type: 'string',
                  description: 'How to format the value. When using duration, make sure the value is seconds OR is converted to seconds using math functions. Ask the user for clarification in which unit the value is stored, or derive it from the field name.',
                  enum: [_common.FIELD_FORMAT_IDS.BYTES, _common.FIELD_FORMAT_IDS.CURRENCY, _common.FIELD_FORMAT_IDS.DURATION, _common.FIELD_FORMAT_IDS.NUMBER, _common.FIELD_FORMAT_IDS.PERCENT, _common.FIELD_FORMAT_IDS.STRING]
                }
              },
              required: ['id']
            }
          },
          required: ['label', 'formula', 'format']
        }
      },
      timeField: {
        type: 'string',
        default: '@timefield',
        description: 'time field to use for XY chart. Use @timefield if its available on the index.'
      },
      breakdown: {
        type: 'object',
        additionalProperties: false,
        properties: {
          field: {
            type: 'string'
          }
        },
        required: ['field']
      },
      indexPattern: {
        type: 'string'
      },
      seriesType: {
        type: 'string',
        enum: [SeriesType.Area, SeriesType.AreaPercentageStacked, SeriesType.AreaStacked, SeriesType.Bar, SeriesType.BarHorizontal, SeriesType.BarHorizontalPercentageStacked, SeriesType.BarPercentageStacked, SeriesType.BarStacked, SeriesType.Line]
      },
      start: {
        type: 'string',
        description: 'The start of the time range, in Elasticsearch datemath'
      },
      end: {
        type: 'string',
        description: 'The end of the time range, in Elasticsearch datemath'
      }
    },
    required: ['layers', 'indexPattern', 'start', 'end', 'timeField']
  }
};
exports.lensFunctionDefinition = lensFunctionDefinition;