"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TopNavMenuExtensionsRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class TopNavMenuExtensionsRegistry {
  constructor() {
    (0, _defineProperty2.default)(this, "menuItems", void 0);
    this.menuItems = [];
  }

  /** @public **/
  // Items registered into this registry will be appended to any TopNavMenu rendered in any application.
  register(menuItem) {
    this.menuItems.push(menuItem);
  }

  /** @internal **/
  getAll() {
    return this.menuItems;
  }

  /** @internal **/
  clear() {
    this.menuItems.length = 0;
  }
}
exports.TopNavMenuExtensionsRegistry = TopNavMenuExtensionsRegistry;