"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.asChildFunctionRenderer = void 0;
exports.composeStateUpdaters = composeStateUpdaters;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const asChildFunctionRenderer = (hoc, {
  onInitialize,
  onCleanup
} = {}) => hoc(class ChildFunctionRenderer extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "displayName", 'ChildFunctionRenderer');
    (0, _defineProperty2.default)(this, "getRendererArgs", () => (0, _lodash.omit)(this.props, ['children', 'initializeOnMount', 'resetOnUnmount']));
  }
  componentDidMount() {
    if (this.props.initializeOnMount && onInitialize) {
      onInitialize(this.getRendererArgs());
    }
  }
  componentWillUnmount() {
    if (this.props.resetOnUnmount && onCleanup) {
      onCleanup(this.getRendererArgs());
    }
  }
  render() {
    return this.props.children(this.getRendererArgs());
  }
});
exports.asChildFunctionRenderer = asChildFunctionRenderer;
function composeStateUpdaters(...updaters) {
  return (state, props) => updaters.reduce((currentState, updater) => updater(currentState, props) || currentState, state);
}