"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.decorateShards = decorateShards;
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function decorateShards(shards, nodes) {
  function getTooltipMessage(shard) {
    const isRelocating = node => (0, _lodash.includes)(node.node_ids, shard.relocating_node);
    const nodeName = (0, _lodash.get)((0, _lodash.find)(nodes, n => isRelocating(n)), 'name');

    // messages for relocating node
    if (nodeName) {
      if (shard.state === 'INITIALIZING') {
        return _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.decorateShards.relocatingFromTextMessage', {
          defaultMessage: 'Relocating from {nodeName}',
          values: {
            nodeName
          }
        });
      }
      if (shard.state === 'RELOCATING') {
        return _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.decorateShards.relocatingToTextMessage', {
          defaultMessage: 'Relocating to {nodeName}',
          values: {
            nodeName
          }
        });
      }
    }
    const state = (0, _lodash.get)(shard, 'state', (0, _lodash.get)(shard, 'shard.state'));
    return (0, _lodash.upperFirst)(state.toLowerCase());
  }
  return shards.map(shard => {
    const node = nodes[shard.node];
    shard.nodeName = node && node.name || null;
    shard.type = 'shard';
    shard.tooltip_message = getTooltipMessage(shard);
    return shard;
  });
}